/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectIntBufferRU;
import java.nio.IntBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectIntBufferU
extends IntBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    protected static final boolean unaligned = Bits.unaligned();
    protected Object viewedBuffer = null;

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    public Cleaner cleaner() {
        return null;
    }

    DirectIntBufferU(DirectBuffer directBuffer, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5);
        this.address = directBuffer.address() + (long)n6;
        this.viewedBuffer = directBuffer;
    }

    public IntBuffer slice() {
        int n2 = this.position();
        int n3 = this.limit();
        assert (n2 <= n3);
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n2 << 2;
        assert (n5 >= 0);
        return new DirectIntBufferU(this, -1, 0, n4, n4, n5);
    }

    public IntBuffer duplicate() {
        return new DirectIntBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public IntBuffer asReadOnlyBuffer() {
        return new DirectIntBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public long address() {
        return this.address;
    }

    private long ix(int n2) {
        return this.address + (long)(n2 << 2);
    }

    public int get() {
        return unsafe.getInt(this.ix(this.nextGetIndex()));
    }

    public int get(int n2) {
        return unsafe.getInt(this.ix(this.checkIndex(n2)));
    }

    public IntBuffer get(int[] nArray, int n2, int n3) {
        if (n3 << 2 > 6) {
            int n4;
            DirectIntBufferU.checkBounds(n2, n3, nArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToIntArray(this.ix(n5), nArray, n2 << 2, n3 << 2);
            } else {
                Bits.copyToByteArray(this.ix(n5), nArray, n2 << 2, n3 << 2);
            }
            this.position(n5 + n3);
        } else {
            super.get(nArray, n2, n3);
        }
        return this;
    }

    public IntBuffer put(int n2) {
        unsafe.putInt(this.ix(this.nextPutIndex()), n2);
        return this;
    }

    public IntBuffer put(int n2, int n3) {
        unsafe.putInt(this.ix(this.checkIndex(n2)), n3);
        return this;
    }

    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer instanceof DirectIntBufferU) {
            int n2;
            if (intBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectIntBufferU directIntBufferU = (DirectIntBufferU)intBuffer;
            int n3 = directIntBufferU.position();
            int n4 = directIntBufferU.limit();
            assert (n3 <= n4);
            int n5 = n3 <= n4 ? n4 - n3 : 0;
            int n6 = this.position();
            int n7 = this.limit();
            assert (n6 <= n7);
            int n8 = n2 = n6 <= n7 ? n7 - n6 : 0;
            if (n5 > n2) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directIntBufferU.ix(n3), this.ix(n6), n5 << 2);
            directIntBufferU.position(n3 + n5);
            this.position(n6 + n5);
        } else if (!intBuffer.isDirect()) {
            int n9 = intBuffer.position();
            int n10 = intBuffer.limit();
            assert (n9 <= n10);
            int n11 = n9 <= n10 ? n10 - n9 : 0;
            this.put(intBuffer.hb, intBuffer.offset + n9, n11);
            intBuffer.position(n9 + n11);
        } else {
            super.put(intBuffer);
        }
        return this;
    }

    public IntBuffer put(int[] nArray, int n2, int n3) {
        if (n3 << 2 > 6) {
            int n4;
            DirectIntBufferU.checkBounds(n2, n3, nArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromIntArray(nArray, n2 << 2, this.ix(n5), n3 << 2);
            } else {
                Bits.copyFromByteArray(nArray, n2 << 2, this.ix(n5), n3 << 2);
            }
            this.position(n5 + n3);
        } else {
            super.put(nArray, n2, n3);
        }
        return this;
    }

    public IntBuffer compact() {
        int n2 = this.position();
        int n3 = this.limit();
        assert (n2 <= n3);
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        unsafe.copyMemory(this.ix(n2), this.ix(0), n4 << 2);
        this.position(n4);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

