/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.util;

import java.util.Map;

public final class PolicyUtils {
    public static final int NOPLAINTEXT = 1;
    public static final int NOACTIVE = 2;
    public static final int NODICTIONARY = 4;
    public static final int FORWARD_SECRECY = 8;
    public static final int NOANONYMOUS = 16;
    public static final int PASS_CREDENTIALS = 512;

    private PolicyUtils() {
    }

    public static boolean checkPolicy(int n2, Map map) {
        if (map == null) {
            return true;
        }
        if ("true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.noplaintext")) && (n2 & 1) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.noactive")) && (n2 & 2) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.nodictionary")) && (n2 & 4) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.noanonymous")) && (n2 & 0x10) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.forward")) && (n2 & 8) == 0) {
            return false;
        }
        return !"true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.credentials")) || (n2 & 0x200) != 0;
    }

    public static String[] filterMechs(String[] stringArray, int[] nArray, Map map) {
        if (map == null) {
            return (String[])stringArray.clone();
        }
        boolean[] blArray = new boolean[stringArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            blArray[i2] = PolicyUtils.checkPolicy(nArray[i2], map);
            if (!blArray[i2]) continue;
            ++n2;
        }
        String[] stringArray2 = new String[n2];
        int n3 = 0;
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            if (!blArray[i3]) continue;
            stringArray2[n3++] = stringArray[i3];
        }
        return stringArray2;
    }
}

