/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.res.XMLMessages;
import com.sun.org.apache.xml.internal.serializer.ToStream;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ToTextStream
extends ToStream {
    protected void startDocumentInternal() throws SAXException {
        super.startDocumentInternal();
        this.m_needToCallStartDocument = false;
    }

    public void endDocument() throws SAXException {
        this.flushPending();
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.m_tracer != null) {
            super.fireStartElem(string3);
            this.firePseudoAttributes();
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEndElem(string3);
        }
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        this.flushPending();
        try {
            this.writeNormalizedChars(cArray, n2, n3, false, this.m_lineSepUse);
            if (this.m_tracer != null) {
                super.fireCharEvent(cArray, n2, n3);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void charactersRaw(char[] cArray, int n2, int n3) throws SAXException {
        try {
            this.writeNormalizedChars(cArray, n2, n3, false, this.m_lineSepUse);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    void writeNormalizedChars(char[] cArray, int n2, int n3, boolean bl2, boolean bl3) throws IOException, SAXException {
        Writer writer = this.m_writer;
        int n4 = n2 + n3;
        int n5 = this.m_maxCharacter;
        if (bl2) {
            for (int i2 = n2; i2 < n4; ++i2) {
                char c2 = cArray[i2];
                if ('\n' == c2 && bl3) {
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    continue;
                }
                if (c2 > n5) {
                    if (i2 != 0) {
                        this.closeCDATA();
                    }
                    if (ToTextStream.isUTF16Surrogate(c2)) {
                        this.writeUTF16Surrogate(c2, cArray, i2, n4);
                        ++i2;
                    } else {
                        writer.write(c2);
                    }
                    if (i2 == 0 || i2 >= n4 - 1) continue;
                    writer.write("<![CDATA[");
                    this.m_cdataTagOpen = true;
                    continue;
                }
                if (i2 < n4 - 2 && ']' == c2 && ']' == cArray[i2 + 1] && '>' == cArray[i2 + 2]) {
                    writer.write("]]]]><![CDATA[>");
                    i2 += 2;
                    continue;
                }
                if (c2 <= n5) {
                    writer.write(c2);
                    continue;
                }
                if (ToTextStream.isUTF16Surrogate(c2)) {
                    this.writeUTF16Surrogate(c2, cArray, i2, n4);
                    ++i2;
                    continue;
                }
                String string = this.getEncoding();
                if (string != null) {
                    String string2 = Integer.toString(c2);
                    throw new SAXException(XMLMessages.createXMLMessage("ER_ILLEGAL_CHARACTER", new Object[]{string2, string}));
                }
                writer.write(c2);
            }
        } else {
            for (int i3 = n2; i3 < n4; ++i3) {
                char c3 = cArray[i3];
                if ('\n' == c3 && bl3) {
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    continue;
                }
                if (c3 <= n5) {
                    writer.write(c3);
                    continue;
                }
                if (ToTextStream.isUTF16Surrogate(c3)) {
                    this.writeUTF16Surrogate(c3, cArray, i3, n4);
                    ++i3;
                    continue;
                }
                String string = this.getEncoding();
                if (string != null) {
                    String string3 = Integer.toString(c3);
                    throw new SAXException(XMLMessages.createXMLMessage("ER_ILLEGAL_CHARACTER", new Object[]{string3, string}));
                }
                writer.write(c3);
            }
        }
    }

    public void cdata(char[] cArray, int n2, int n3) throws SAXException {
        try {
            this.writeNormalizedChars(cArray, n2, n3, false, this.m_lineSepUse);
            if (this.m_tracer != null) {
                super.fireCDATAEvent(cArray, n2, n3);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        try {
            this.writeNormalizedChars(cArray, n2, n3, false, this.m_lineSepUse);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushPending();
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    public void comment(String string) throws SAXException {
        int n2 = string.length();
        if (n2 > this.m_charsBuff.length) {
            this.m_charsBuff = new char[n2 * 2 + 1];
        }
        string.getChars(0, n2, this.m_charsBuff, 0);
        this.comment(this.m_charsBuff, 0, n2);
    }

    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        this.flushPending();
        if (this.m_tracer != null) {
            super.fireCommentEvent(cArray, n2, n3);
        }
    }

    public void entityReference(String string) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEntityReference(string);
        }
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) {
    }

    public void endCDATA() throws SAXException {
    }

    public void endElement(String string) throws SAXException {
        if (this.m_tracer != null) {
            super.fireEndElem(string);
        }
    }

    public void startElement(String string, String string2, String string3) throws SAXException {
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
        }
        if (this.m_tracer != null) {
            super.fireStartElem(string3);
            this.firePseudoAttributes();
        }
    }

    public void characters(String string) throws SAXException {
        int n2 = string.length();
        if (n2 > this.m_charsBuff.length) {
            this.m_charsBuff = new char[n2 * 2 + 1];
        }
        string.getChars(0, n2, this.m_charsBuff, 0);
        this.characters(this.m_charsBuff, 0, n2);
    }

    public void addAttribute(String string, String string2) {
    }

    public void addUniqueAttribute(String string, String string2, int n2) throws SAXException {
    }

    public boolean startPrefixMapping(String string, String string2, boolean bl2) throws SAXException {
        return false;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
    }

    public void flushPending() throws SAXException {
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
    }
}

