/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil.concurrent;

import com.sun.corba.se.impl.orbutil.concurrent.Sync;
import org.omg.CORBA.INTERNAL;

public class DebugMutex
implements Sync {
    protected boolean inuse_ = false;
    protected Thread holder_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        DebugMutex debugMutex = this;
        synchronized (debugMutex) {
            Thread thread = Thread.currentThread();
            if (this.holder_ == thread) {
                throw new INTERNAL("Attempt to acquire Mutex by thread holding the Mutex");
            }
            try {
                while (this.inuse_) {
                    this.wait();
                }
                this.inuse_ = true;
                this.holder_ = Thread.currentThread();
            }
            catch (InterruptedException interruptedException) {
                this.notify();
                throw interruptedException;
            }
        }
    }

    public synchronized void release() {
        Thread thread = Thread.currentThread();
        if (thread != this.holder_) {
            throw new INTERNAL("Attempt to release Mutex by thread not holding the Mutex");
        }
        this.holder_ = null;
        this.inuse_ = false;
        this.notify();
    }

    public boolean attempt(long l2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        DebugMutex debugMutex = this;
        synchronized (debugMutex) {
            Thread thread = Thread.currentThread();
            if (!this.inuse_) {
                this.inuse_ = true;
                this.holder_ = thread;
                return true;
            }
            if (l2 <= 0L) {
                return false;
            }
            long l3 = l2;
            long l4 = System.currentTimeMillis();
            try {
                do {
                    this.wait(l3);
                    if (this.inuse_) continue;
                    this.inuse_ = true;
                    this.holder_ = thread;
                    return true;
                } while ((l3 = l2 - (System.currentTimeMillis() - l4)) > 0L);
                return false;
            }
            catch (InterruptedException interruptedException) {
                this.notify();
                throw interruptedException;
            }
        }
    }
}

