/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import java.io.IOException;

public class Packet {
    public static final short NoFlags = 0;
    public static final short Reply = 128;
    public static final short ReplyNoError = 0;
    static int uID = 1;
    static final byte[] nullData = new byte[0];
    int id = Packet.uniqID();
    short flags = 0;
    short cmdSet;
    short cmd;
    short errorCode;
    byte[] data = nullData;
    volatile boolean replied = false;

    public byte[] toByteArray() {
        int n = this.data.length + 11;
        byte[] byArray = new byte[n];
        byArray[0] = (byte)(n >>> 24 & 0xFF);
        byArray[1] = (byte)(n >>> 16 & 0xFF);
        byArray[2] = (byte)(n >>> 8 & 0xFF);
        byArray[3] = (byte)(n >>> 0 & 0xFF);
        byArray[4] = (byte)(this.id >>> 24 & 0xFF);
        byArray[5] = (byte)(this.id >>> 16 & 0xFF);
        byArray[6] = (byte)(this.id >>> 8 & 0xFF);
        byArray[7] = (byte)(this.id >>> 0 & 0xFF);
        byArray[8] = (byte)this.flags;
        if ((this.flags & 0x80) == 0) {
            byArray[9] = (byte)this.cmdSet;
            byArray[10] = (byte)this.cmd;
        } else {
            byArray[9] = (byte)(this.errorCode >>> 8 & 0xFF);
            byArray[10] = (byte)(this.errorCode >>> 0 & 0xFF);
        }
        if (this.data.length > 0) {
            System.arraycopy(this.data, 0, byArray, 11, this.data.length);
        }
        return byArray;
    }

    public static Packet fromByteArray(byte[] byArray) throws IOException {
        if (byArray.length < 11) {
            throw new IOException("packet is insufficient size");
        }
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        int n5 = n << 24 | n2 << 16 | n3 << 8 | n4 << 0;
        if (n5 != byArray.length) {
            throw new IOException("length size mis-match");
        }
        int n6 = byArray[4] & 0xFF;
        int n7 = byArray[5] & 0xFF;
        int n8 = byArray[6] & 0xFF;
        int n9 = byArray[7] & 0xFF;
        Packet packet = new Packet();
        packet.id = n6 << 24 | n7 << 16 | n8 << 8 | n9 << 0;
        packet.flags = (short)(byArray[8] & 0xFF);
        if ((packet.flags & 0x80) == 0) {
            packet.cmdSet = (short)(byArray[9] & 0xFF);
            packet.cmd = (short)(byArray[10] & 0xFF);
        } else {
            short s = (short)(byArray[9] & 0xFF);
            short s2 = (short)(byArray[10] & 0xFF);
            packet.errorCode = (short)((s << 8) + (s2 << 0));
        }
        packet.data = new byte[byArray.length - 11];
        System.arraycopy(byArray, 11, packet.data, 0, packet.data.length);
        return packet;
    }

    Packet() {
    }

    private static synchronized int uniqID() {
        return uID++;
    }
}

