/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.mirror.util;

import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.Types;
import com.sun.tools.apt.mirror.AptEnv;
import com.sun.tools.apt.mirror.declaration.DeclarationImpl;
import com.sun.tools.apt.mirror.declaration.TypeDeclarationImpl;
import com.sun.tools.apt.mirror.type.TypeMirrorImpl;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.ListBuffer;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesImpl
implements Types {
    private final AptEnv env;
    private static final Context.Key<Types> typesKey = new Context.Key();

    public static Types instance(Context context) {
        Types types = context.get(typesKey);
        if (types == null) {
            types = new TypesImpl(context);
        }
        return types;
    }

    private TypesImpl(Context context) {
        context.put(typesKey, this);
        this.env = AptEnv.instance(context);
    }

    @Override
    public boolean isSubtype(TypeMirror typeMirror, TypeMirror typeMirror2) {
        return this.env.jctypes.isSubType(((TypeMirrorImpl)typeMirror).type, ((TypeMirrorImpl)typeMirror2).type);
    }

    @Override
    public boolean isAssignable(TypeMirror typeMirror, TypeMirror typeMirror2) {
        return this.env.jctypes.isAssignable(((TypeMirrorImpl)typeMirror).type, ((TypeMirrorImpl)typeMirror2).type);
    }

    @Override
    public TypeMirror getErasure(TypeMirror typeMirror) {
        return this.env.typeMaker.getType(this.env.jctypes.erasure(((TypeMirrorImpl)typeMirror).type));
    }

    @Override
    public PrimitiveType getPrimitiveType(PrimitiveType.Kind kind) {
        Type type = null;
        switch (kind) {
            case BOOLEAN: {
                type = this.env.symtab.booleanType;
                break;
            }
            case BYTE: {
                type = this.env.symtab.byteType;
                break;
            }
            case SHORT: {
                type = this.env.symtab.shortType;
                break;
            }
            case INT: {
                type = this.env.symtab.intType;
                break;
            }
            case LONG: {
                type = this.env.symtab.longType;
                break;
            }
            case CHAR: {
                type = this.env.symtab.charType;
                break;
            }
            case FLOAT: {
                type = this.env.symtab.floatType;
                break;
            }
            case DOUBLE: {
                type = this.env.symtab.doubleType;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return (PrimitiveType)this.env.typeMaker.getType(type);
    }

    @Override
    public VoidType getVoidType() {
        return (VoidType)this.env.typeMaker.getType(this.env.symtab.voidType);
    }

    @Override
    public ArrayType getArrayType(TypeMirror typeMirror) {
        if (typeMirror instanceof VoidType) {
            throw new IllegalArgumentException("void");
        }
        return (ArrayType)this.env.typeMaker.getType(new Type.ArrayType(((TypeMirrorImpl)typeMirror).type, (Symbol.TypeSymbol)this.env.symtab.arrayClass));
    }

    @Override
    public TypeVariable getTypeVariable(TypeParameterDeclaration typeParameterDeclaration) {
        return (TypeVariable)this.env.typeMaker.getType(((DeclarationImpl)((Object)typeParameterDeclaration)).sym.type);
    }

    @Override
    public WildcardType getWildcardType(Collection<ReferenceType> collection, Collection<ReferenceType> collection2) {
        Type type;
        BoundKind boundKind;
        int n;
        int n2 = collection.size();
        if (n2 + (n = collection2.size()) > 1) {
            throw new IllegalArgumentException("Multiple bounds not allowed");
        }
        if (n2 + n == 0) {
            boundKind = BoundKind.UNBOUND;
            type = this.env.symtab.objectType;
        } else if (n2 == 1) {
            assert (n == 0);
            boundKind = BoundKind.EXTENDS;
            type = ((TypeMirrorImpl)((Object)collection.iterator().next())).type;
        } else {
            assert (n2 == 0 && n == 1);
            boundKind = BoundKind.SUPER;
            type = ((TypeMirrorImpl)((Object)collection2.iterator().next())).type;
        }
        if (type instanceof Type.ArgumentType) {
            throw new IllegalArgumentException(type.toString());
        }
        return (WildcardType)this.env.typeMaker.getType(new Type.ArgumentType(type, boundKind, this.env.symtab.boundClass));
    }

    @Override
    public DeclaredType getDeclaredType(TypeDeclaration typeDeclaration, TypeMirror ... typeMirrorArray) {
        Symbol.ClassSymbol classSymbol = ((TypeDeclarationImpl)typeDeclaration).sym;
        if (typeMirrorArray.length == 0) {
            return (DeclaredType)this.env.typeMaker.getType(this.env.jctypes.erasure(classSymbol.type));
        }
        if (classSymbol.type.outer().isParameterized()) {
            throw new IllegalArgumentException(typeDeclaration.toString());
        }
        return this.getDeclaredType(classSymbol.type.outer(), classSymbol, typeMirrorArray);
    }

    @Override
    public DeclaredType getDeclaredType(DeclaredType declaredType, TypeDeclaration typeDeclaration, TypeMirror ... typeMirrorArray) {
        if (declaredType == null) {
            return this.getDeclaredType(typeDeclaration, typeMirrorArray);
        }
        Symbol.ClassSymbol classSymbol = ((TypeDeclarationImpl)typeDeclaration).sym;
        Type type = ((TypeMirrorImpl)((Object)declaredType)).type;
        if (type.tsym != classSymbol.owner.enclClass()) {
            throw new IllegalArgumentException(declaredType.toString());
        }
        if (!type.isParameterized()) {
            return this.getDeclaredType(typeDeclaration, typeMirrorArray);
        }
        return this.getDeclaredType(type, classSymbol, typeMirrorArray);
    }

    private DeclaredType getDeclaredType(Type type, Symbol.ClassSymbol classSymbol, TypeMirror ... typeMirrorArray) {
        if (typeMirrorArray.length != classSymbol.type.typarams().length()) {
            throw new IllegalArgumentException("Incorrect number of type arguments");
        }
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (TypeMirror typeMirror : typeMirrorArray) {
            if (!(typeMirror instanceof ReferenceType) && !(typeMirror instanceof WildcardType)) {
                throw new IllegalArgumentException(((Object)typeMirror).toString());
            }
            listBuffer.append(((TypeMirrorImpl)typeMirror).type);
        }
        return (DeclaredType)this.env.typeMaker.getType(new Type.ClassType(type, listBuffer.toList(), classSymbol));
    }
}

