// exporter.h
// Copyright (C)  2003  Dominique Devriese <devriese@kde.org>

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.

#ifndef KIG_FILTERS_EXPORTER_H
#define KIG_FILTERS_EXPORTER_H

#include <vector>

class QString;
class KigDocument;
class KigWidget;
class KActionCollection;

class KigExporter;

class KigExportManager
{
  std::vector<KigExporter*> mexporters;
  KigExportManager();
  ~KigExportManager();
public:
  static KigExportManager* instance();
  void addMenuAction( const KigDocument* doc, KigWidget* w,
                      KActionCollection* coll );
};

class KigExporter
{
public:
  virtual ~KigExporter();

  /**
   * Returns a statement like i18n( "Export to image" )
   */
  virtual QString exportToStatement() const = 0;
  /**
   * Returns a string like i18n( "Image..." )
   */
  virtual QString menuEntryName() const = 0;

  /**
   * Do what you need to do.  It's up to the individual exporters to
   * ask the user for which file to export to etc., because they can
   * do a much better job at that..
   */
  virtual void run( const KigDocument& doc, KigWidget& w ) = 0;
};

/**
 * This exporter takes care of the "Export to Image" stuff..
 */
class ImageExporter
  : public KigExporter
{
public:
  ~ImageExporter();
  QString exportToStatement() const;
  QString menuEntryName() const;
  void run( const KigDocument& doc, KigWidget& w );
};

/**
 * Guess what this one does ;)
 * It exports to the XFig file format, as documented in the file
 * FORMAT3.2 in the XFig source distribution.
 */
class XFigExporter
  : public KigExporter
{
public:
  ~XFigExporter();
  QString exportToStatement() const;
  QString menuEntryName() const;
  void run( const KigDocument& doc, KigWidget& w );
};
#endif
