#!/usr/bin/env kjscmd
if ( !include("kjsuic.js") )
{
	alert("Couldn't find kjsuic.js.  Please make sure its installed!");
	exit();
}

StdDirs.addResourceType("buttonmaker", StdDirs.kde_default("data") + "/buttonmaker");

var imgfx = new ImageFX();

var win = new KMainWindow(this);
var view = kjsuic(StdDirs.findResource("buttonmaker", "ButtonMakerUI.ui"), this, win);

win.connect(view.Save, 'clicked()', this, 'saveImage');
win.connect(view.Exit, 'clicked()', this, 'exit');
win.connect(view.Reset, 'clicked()', this, 'resetView');

win.connect(view.TextBox.Font, 'fontSelected(const QFont&)', this, 'updateUI' );
win.connect(view.TextBox.TextColors, 'fgChanged(const QColor&)', this, 'updateUI' );
win.connect(view.TextBox.TextColors, 'bgChanged(const QColor&)', this, 'updateUI' );
win.connect(view.TextBox.Offset, 'valueChanged(int)', this, 'updateUI' );

win.connect(view.Text, 'returnPressed(const QString&)', this, 'updateUI');

win.connect(view.Mode, 'released(int)', this, 'changeMode');
win.connect(view.Mode.Xsize, 'valueChanged(int)', this, 'updatePillBox' );
win.connect(view.Mode.Ysize, 'valueChanged(int)', this, 'updatePillBox' );
win.connect(view.Mode.BaseColor, 'changed(const QColor&)', this, 'updatePillBox' );
win.connect(view.Mode.BaseImage, 'urlSelected(const QString&)', this, 'loadImage');

var bgimage = new Pixmap(this);
resetView();

win.setCentralWidget(view);
win.setCaption("ButtonMaker");
win.show();
application.exec();

function CustomPillBox()
{
	this.a = new Image(this);
	this.b = new Image(this);
	this.c = new Image(this);
	this.d = new Image(this);
	this.e = new Image(this);
	this.f = new Image(this);
	this.g = new Image(this);
	this.h = new Image(this);
	this.i = new Image(this);

	this.height = function() {
		return this.a.height() + this.d.height() + this.g.height();
	}

	this.width = function() {
		return this.a.width() + this.b.width() + this.c.width();
	}

	this.loadImages = function() {
		return (
		this.a.load(StdDirs.findResource("buttonmaker", "01.png")) &&
		this.b.load(StdDirs.findResource("buttonmaker", "02.png")) &&
		this.c.load(StdDirs.findResource("buttonmaker", "03.png")) &&
		this.d.load(StdDirs.findResource("buttonmaker", "04.png")) &&
		this.e.load(StdDirs.findResource("buttonmaker", "05.png")) &&
		this.f.load(StdDirs.findResource("buttonmaker", "06.png")) &&
		this.g.load(StdDirs.findResource("buttonmaker", "07.png")) &&
		this.h.load(StdDirs.findResource("buttonmaker", "08.png")) &&
		this.i.load(StdDirs.findResource("buttonmaker", "09.png")));
	}

	this.colorize = function( color ) {
		var percent = 0.55;
		this.a = imgfx.blendColor( color, this.a, percent);
		this.b = imgfx.blendColor( color, this.b, percent);
		this.c = imgfx.blendColor( color, this.c, percent);
		this.d = imgfx.blendColor( color, this.d, percent);
		this.e = imgfx.blendColor( color, this.e, percent);
		this.f = imgfx.blendColor( color, this.f, percent);
		this.g = imgfx.blendColor( color, this.g, percent);
		this.h = imgfx.blendColor( color, this.h, percent);
		this.i = imgfx.blendColor( color, this.i, percent);
	}

	this.resize = function( newW, newH ) {

		this.b.smoothScale( newW - ( this.a.width() + this.c.width() ), this.b.height() );
		this.h.smoothScale( newW - ( this.g.width() + this.i.width() ), this.h.height() );

		this.d.smoothScale( this.d.width(), newH - ( this.a.height() + this.g.height() ) );
		this.f.smoothScale( this.f.width(), newH - ( this.c.height() + this.i.height() ) );

		this.e.smoothScale( newW - ( this.a.width() + this.c.width() ),
			 newH - ( this.c.height() + this.i.height() ) );
	}

	this.pixmap = function(width, height){
		this.resize(width, height);
		var pix = new Pixmap(this);
		pix.resize(width, height);
		pix.fill("white");

		var painter = new Painter(this);
		if( painter.begin(pix) )
		{
			//painter.drawRect(0,0,this.width(), this.height());
			painter.drawImage(0, 0, this.a, 0, 0, -1, -1, 0);
			painter.drawImage(0, this.a.height(), this.d, 0, 0, -1, -1, 0);
			painter.drawImage(0, ( this.height() - this.g.height() ) ,this.g, 0, 0, -1, -1, 0);

			painter.drawImage(this.a.width(), 0, this.b, 0, 0, -1, -1, 0);
			painter.drawImage(this.d.width(), this.b.height(), this.e, 0, 0, -1, -1, 0);
			painter.drawImage(this.g.width(), ( this.height() - this.h.height() ) ,this.h, 0, 0, -1, -1, 0);

			painter.drawImage(this.a.width() + this.b.width(), 0, this.c, 0, 0, -1, -1, 0);
			painter.drawImage(this.d.width() + this.e.width(), this.c.height(), this.f, 0, 0, -1, -1, 0);
			painter.drawImage(this.g.width() + this.h.width(), ( this.height() - this.i.height() ) ,this.i, 0, 0, -1, -1, 0);
			if( painter.end() )
				pix = painter.pixmap();
		}
		return pix;
	}

}

function render(txt, bgimg, font, offset, fgColor, bgColor)
{
	var h = bgimg.height();
	var w = bgimg.width();
	var fg = new Pen(this);
	var bg = new Pen(this);
	fg.setColor(fgColor);
	bg.setColor(bgColor);

	var painter = new Painter(this);

	if (painter.begin(bgimg))
	{
		painter.scale( view.Mode.Xscale.value, view.Mode.Yscale.value );
		painter.setPen(bg);
		painter.setFont(font);
		var box = painter.textBox(txt);
		var txtX = (w/2) - (box[2]/2);
		var txtY = (h/2) + (box[3]/2);
		painter.drawText(txtX+offset,txtY+offset,txt);
		painter.setPen(fg);
		painter.drawText(txtX,txtY,txt);

	}
	if ( painter.end() )
		return painter.pixmap();
	else
		return new Pixmap(this);
}

function changeMode(mode)
{
	if( mode == 0)
	{
		loadImage(view.Mode.BaseImage.url);
	}
	else
	{
		var pb = new CustomPillBox();
		if ( !pb.loadImages() )
			alert("Error Loading Resources!");
		else
		{
			pb.colorize(view.Mode.BaseColor.color);
			bgimage = pb.pixmap(view.Mode.Xsize.value,view.Mode.Ysize.value);
		}
		updateUI();
	}
}

function updatePillBox()
{
	var pb = new CustomPillBox();
	if ( !pb.loadImages() )
		alert("Error Loading Resources!");
	else
	{
		pb.colorize(view.Mode.BaseColor.color);
		bgimage = pb.pixmap(view.Mode.Xsize.value,view.Mode.Ysize.value);
	}
	updateUI();
}

function updateUI()
{
	view.PreviewBox.Preview.pixmap = render(view.Text.text, bgimage, view.TextBox.Font.font, view.TextBox.Offset.value, view.TextBox.TextColors.foreground, view.TextBox.TextColors.background);
	win.adjustSize();

}

function saveImage()
{
	var img = new Image(this);
	var fileName = StdDialog.getSaveFileName();
	if( fileName != "")
	{
		img.setPixmap(render(view.Text.text, bgimage, view.TextBox.Font.font, view.TextBox.Offset.value, view.TextBox.TextColors.foreground, view.TextBox.TextColors.background));
		img.save(fileName);
	}
}

function resetView()
{
	view.TextBox.Offset.value = 1;
	if ( application.args.length > 0 )
		view.Text.text = application.args[0];
	else
		view.Text.text = "";
	view.TextBox.Font.font = "";
	view.TextBox.TextColors.foreground = "black";
	view.TextBox.TextColors.background = "white";
	view.Mode.BaseImage.url = StdDirs.findResource("buttonmaker", "default.png");
	loadImage(view.Mode.BaseImage.url);
}

function loadImage(file)
{
	var img = new Image(this);
	if (img.load(file) )
	{
		bgimage = img.pixmap();
		updateUI();
	}
}