/***************************************************************************
                            KRun.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KRUN_H
#define KRUN_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 To open files with their associated applications in KDE, use KRun.

 It can execute any desktop entry, as well as any file, using
 the default application or another application "bound" to the file type.

 In that example, the mimetype of the file is not known by the application,
 so a KRun instance must be created. It will determine the mimetype by itself.
 If the mimetype is known, or if you even know the service (application) to
 use for this file, use one of the static methods.

 @short Opens files with their associated applications in KDE.
*/
@class Job; 
@class KProcess; 
@class KService; 
@class KURL; 

@interface KRun : QObject 

/** 
 Create a KRun object to run the preferred application for a file/URL.
 KRun will first determine the type of the file, and will then
 run the associated application.

*/
- initWithURL: (KURL*)url mode: (long)mode isLocalFile: (BOOL)isLocalFile showProgressInfo: (BOOL)showProgressInfo;
- initWithURL: (KURL*)url ;

/** 
 Destructor. Don't call it yourself, since a KRun object auto-deletes
 itself.
   
*/
- (void) dealloc;

/** 
 Abort this KRun. This kills any jobs launched by it,
 and leads to deletion if auto-deletion is on.
 This is much safer than deleting the KRun (in case it's
 currently showing an error dialog box, for instance)
   
*/
- abort;
- (BOOL) hasError;
- (BOOL) hasFinished;

/** 
 By default auto deletion is on.
   
*/
- (BOOL) autoDelete;
- setAutoDelete: (BOOL)b;

/** 
 Open a list of URLs with a certain service.

*/
+ (long) run: (KService*)_service _urls: (NSArray *)_urls;

/** 
 Open a list of URLs with.

*/
+ (long) runExec: (NSString *)_exec _urls: (NSArray *)_urls _name: (NSString *)_name _icon: (NSString *)_icon _obsolete1: (NSString *)_obsolete1 _obsolete2: (NSString *)_obsolete2;
+ (long) runExec: (NSString *)_exec _urls: (NSArray *)_urls ;

/** 
 Open the given URL.

 This function is used after the mime type
 is found out. It will search for all services which can handle
 the mime type and call @ref -run afterwards.
   
*/
+ (long) runURL: (KURL*)_url _mimetype: (NSString *)_mimetype;

/** 
 Run the given shell command and notifies kicker of the starting
 of the application. If the program to be called doesn't exist,
 an error box will be displayed.

 @p _cmd must be a shell command. You must not append "&"
 to it, since the function will do that for you.

 Use only when you know the full command line. Otherwise use the other
 static methods, or KRun's constructor.
   
*/
+ (long) runCommand: (NSString *)cmd;

/** 
 Same as the other runCommand, but it also takes the name of the
 binary, to display an error message in case it couldn't find it.

*/
+ (long) runCommand: (NSString *)cmd execName: (NSString *)execName icon: (NSString *)icon;

/** 
 Display the Open-With dialog for those URLs, and run the chosen application.

*/
+ (BOOL) displayOpenWithDialog: (NSArray *)lst;

/** 
 Quotes a string for the shell
   
*/
+ shellQuote: (NSString *)_str;

/** 
 Processes a Exec= line as found in .desktop files.

*/
+ (NSArray *) processDesktopExec: (KService*)_service _urls: (NSArray *)_urls has_shell: (BOOL)has_shell;
- init;
- scanFile;

/** 
 Called if the mimetype has been detected. The function checks
 whether the document and appends the gzip protocol to the
 URL. Otherwise @ref  #-runURL is called to finish the job.
   
*/
- foundMimeType: (NSString *)_type;
- killJob;
- slotTimeout;
- slotScanFinished: (Job*)arg1;
- slotScanMimeType: (Job*)arg1 type: (NSString *)type;
- slotStatResult: (Job*)arg1;
@end

/** Override these methods in subclasses of KRun to customise event handling behaviour */
@protocol KRunEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
