//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QColor;
import org.kde.qt.QRect;
import org.kde.qt.QFont;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QPoint;
import java.util.Calendar;
import org.kde.qt.QSize;
import java.util.ArrayList;
import org.kde.qt.QVariant;
import org.kde.qt.QObject;

/**

 Abstract base class for KDE configuration entries.
 This class forms the base for all KDE configuration. It is an
 abstract base class, meaning that you cannot directly instantiate
 objects of this class. Either use KConfig (for usual KDE
 configuration) or KSimpleConfig (for special needs as in ksamba), or
 even KSharedConfig (stores values in shared memory).
 All configuration entries are key, value pairs.  Each entry also
 belongs to a specific group of related entries.  All configuration
 entries that do not explicitly specify which group they are in are
 in a special group called the default group.
 If there is a $ character in an entry, KConfigBase tries to expand
 environment variable and uses its value instead of its name. You
 can avoid this feature by having two consecutive $ characters in
 your config file which get expanded to one.
 Note: the '=' char is not allowed in keys and the ']' char is not allowed in
 group name.
		@author Kalle Dalheimer <kalle@kde.org>, Preston Brown <pbrown@kde.org>

		@version  kconfigbase.h,v 1.104 2003/11/26 23:28:41 ossi

		@short KDE Configuration Management abstract base class.
		@see KGlobal#config
		@see KConfig
		@see KSimpleConfig

*/
public class KConfigBase extends QObject  {
	protected KConfigBase(Class dummy){super((Class) null);}
	/**	
		 Possible return values for getConfigState().
				@short    Possible return values for getConfigState().
		@see #getConfigState
	*/
	public static final int NoAccess = 0;
	public static final int ReadOnly = 1;
	public static final int ReadWrite = 2;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Construct a KConfigBase object.
		   		@short    Construct a KConfigBase object.
	*/
	/**	
		 Specifies the group in which keys will be read and written.
			  Subsequent
		 calls to readEntry() and writeEntry() will be aplied only in the
		 activated group.
			 Switch back to the default group by passing a null string.
			@param group The name of the new group.
		   		@short    Specifies the group in which keys will be read and written.
	*/
	public native void setGroup(String group);
	/**	
		 Sets the group to the "Desktop Entry" group used for
		 desktop configuration files for applications, mime types, etc.
		   		@short    Sets the group to the "Desktop Entry" group used for  desktop configuration files for applications, mime types, etc.
	*/
	public native void setDesktopGroup();
	/**	
		 Returns the name of the group in which we are
		  searching for keys and from which we are retrieving entries.
				@return The current group.
   
		@short    Returns the name of the group in which we are   searching for keys and from which we are retrieving entries.
	*/
	public native String group();
	/**	
		 Returns true if the specified group is known about.
			@param group The group to search for.
				@return Whether the group exists.
   
		@short    Returns true if the specified group is known about.
	*/
	public native boolean hasGroup(String group);
	/**	
		 Returns a list of groups that are known about.
				@return The list of groups.

		@short    Returns a list of groups that are known about.
	*/
	public native ArrayList groupList();
	/**	
		 Returns a the current locale.
				@return A string representing the current locale.
   
		@short    Returns a the current locale.
	*/
	public native String locale();
	/**	
		 Reads the value of an entry specified by <code>pKey</code> in the current group.
			@param pKey The key to search for.
			@param aDefault A default value returned if the key was not found.
				@return The value for this key. Can be null if aDefault it null.
   
		@short    Reads the value of an entry specified by <code>pKey</code> in the current group.
	*/
	public native String readEntry(String pKey, String aDefault);
	public native String readEntry(String pKey);
	/**	
		 Reads the value of an entry specified by <code>pKey</code> in the current group.
		 The value is treated as if it is of the type of the given default value.
			 Note that only the following QVariant types are allowed : String,
		 StringList, List, Font, Point, Rect, Size, Color, Int, UInt, Bool,
		 Double, DateTime and Date.
			@param pKey The key to search for.
			@param aDefault A default value returned if the key was not found or
		 if the read value cannot be converted to the QVariant.Type.
				@return The value for the key or the default value if the key was not
         found.
   
		@short    Reads the value of an entry specified by <code>pKey</code> in the current group.
	*/
	public native QVariant readPropertyEntry(String pKey, QVariant aDefault);
	/**	
		 Reads a list of strings.
			@param pKey The key to search for.
			@param sep The list separator (default is ",").
				@return The list. Empty if the entry does not exist.
   
		@short    Reads a list of strings.
	*/
	public native ArrayList readListEntry(String pKey, char sep);
	public native ArrayList readListEntry(String pKey);
	/**	
		 Reads a list of Integers.
			@param pKey The key to search for.
				@return The list. Empty if the entry does not exist.
   
		@short    Reads a list of Integers.
	*/
	public native int[] readIntListEntry(String pKey);
	/**	
		 Reads a path.
			 Read the value of an entry specified by <code>pKey</code> in the current group
		 and interpret it as a path. This means, dollar expansion is activated
		 for this value, so that e.g. $HOME gets expanded.
			@param pKey The key to search for.
			@param aDefault A default value returned if the key was not found.
				@return The value for this key. Can be null if aDefault is null.
   
		@short    Reads a path.
	*/
	public native String readPathEntry(String pKey, String aDefault);
	public native String readPathEntry(String pKey);
	/**	
		 Reads a list of string paths.
			 Read the value of an entry specified by <code>pKey</code> in the current group
		 and interpret it as a list of paths. This means, dollar expansion is activated
		 for this value, so that e.g. $HOME gets expanded.
			@param pKey The key to search for.
			@param sep The list separator (default is ",").
				@return The list. Empty if the entry does not exist.

		@short    Reads a list of string paths.
	*/
	public native ArrayList readPathListEntry(String pKey, char sep);
	public native ArrayList readPathListEntry(String pKey);
	/**	
		 Reads a numerical value.
			 Read the value of an entry specified by <code>pKey</code> in the current group
		 and interpret it numerically.
			@param pKey The key to search for.
			@param nDefault A default value returned if the key was not found or if
		 the read value cannot be interpreted.
				@return The value for this key.
   
		@short    Reads a numerical value.
	*/
	public native int readNumEntry(String pKey, int nDefault);
	public native int readNumEntry(String pKey);
	/**	
		 Reads an unsigned numerical value.
			 Read the value of an entry specified by <code>pKey</code> in the current group
		 and interpret it numerically.
			@param pKey The key to search for.
			@param nDefault A default value returned if the key was not found or if
		 the read value cannot be interpreted.
				@return The value for this key.
   
		@short    Reads an unsigned numerical value.
	*/
	public native int readUnsignedNumEntry(String pKey, int nDefault);
	public native int readUnsignedNumEntry(String pKey);
	/**	
		 Reads a numerical value.
			 Read the value of an entry specified by <code>pKey</code> in the current group
		 and interpret it numerically.
			@param pKey The key to search for.
			@param nDefault A default value returned if the key was not found or if
		 the read value cannot be interpreted.
				@return The value for this key.
   
		@short    Reads a numerical value.
	*/
	public native long readLongNumEntry(String pKey, long nDefault);
	public native long readLongNumEntry(String pKey);
	/**	
		 Read an unsigned numerical value.
			 Read the value of an entry specified by <code>pKey</code> in the current group
		 and interpret it numerically.
			@param pKey The key to search for.
			@param nDefault A default value returned if the key was not found or if
		 the read value cannot be interpreted.
				@return The value for this key.
   
		@short    Read an unsigned numerical value.
	*/
	public native long readUnsignedLongNumEntry(String pKey, long nDefault);
	public native long readUnsignedLongNumEntry(String pKey);
	/**	
		 Reads a 64-bit numerical value.
			 Read the value of an entry specified by <code>pKey</code> in the current group
		 and interpret it numerically.
			@param pKey The key to search for.
			@param nDefault A default value returned if the key was not found or if
		 the read value cannot be interpreted.
				@return The value for this key.
   
		@short    Reads a 64-bit numerical value.
	*/
	public native long readNum64Entry(String pKey, long nDefault);
	public native long readNum64Entry(String pKey);
	/**	
		 Read an 64-bit unsigned numerical value.
			 Read the value of an entry specified by <code>pKey</code> in the current group
		 and interpret it numerically.
			@param pKey The key to search for.
			@param nDefault A default value returned if the key was not found or if
		 the read value cannot be interpreted.
				@return The value for this key.
   
		@short    Read an 64-bit unsigned numerical value.
	*/
	public native long readUnsignedNum64Entry(String pKey, long nDefault);
	public native long readUnsignedNum64Entry(String pKey);
	/**	
		 Reads a floating point value.
			 Read the value of an entry specified by <code>pKey</code> in the current group
		 and interpret it numerically.
			@param pKey The key to search for.
			@param nDefault A default value returned if the key was not found or if
		 the read value cannot be interpreted.
				@return The value for this key.
   
		@short    Reads a floating point value.
	*/
	public native double readDoubleNumEntry(String pKey, double nDefault);
	public native double readDoubleNumEntry(String pKey);
	/**	
		 Reads a QFont value.
			 Read the value of an entry specified by <code>pKey</code> in the current group
		 and interpret it as a font object.
			@param pKey The key to search for.
			@param pDefault A default value (null QFont by default) returned if the
		 key was not found or if the read value cannot be interpreted.
				@return The value for this key.
   
		@short    Reads a QFont value.
	*/
	public native QFont readFontEntry(String pKey, QFont pDefault);
	public native QFont readFontEntry(String pKey);
	/**	
		 Reads a booleanean entry.
			 Read the value of an entry specified by <code>pKey</code> in the current group
		 and interpret it as a booleanean value. Currently "on" and "true" are
		 accepted as true, everything else if false.
			@param pKey The key to search for
			@param bDefault A default value returned if the key was not found.
				@return The value for this key.
   
		@short    Reads a boolean entry.
	*/
	public native boolean readBoolEntry(String pKey, boolean bDefault);
	public native boolean readBoolEntry(String pKey);
	/**	
		 Reads a QRect entry.
			 Read the value of an entry specified by pKey in the current group
		 and interpret it as a QRect object.
			@param pKey The key to search for
			@param pDefault A default value (null QRect by default) returned if the
		 key was not found or if the read value cannot be interpreted.
				@return The value for this key.
   
		@short    Reads a QRect entry.
	*/
	public native QRect readRectEntry(String pKey, QRect pDefault);
	public native QRect readRectEntry(String pKey);
	/**	
		 Reads a QPoint entry.
			 Read the value of an entry specified by <code>pKey</code> in the current group
		 and interpret it as a QPoint object.
			@param pKey The key to search for
			@param pDefault A default value (null QPoint by default) returned if the
		 key was not found or if the read value cannot be interpreted.
				@return The value for this key.
   
		@short    Reads a QPoint entry.
	*/
	public native QPoint readPointEntry(String pKey, QPoint pDefault);
	public native QPoint readPointEntry(String pKey);
	/**	
		 Reads a QSize entry.
			 Read the value of an entry specified by <code>pKey</code> in the current group
		 and interpret it as a QSize object.
			@param pKey The key to search for
			@param pDefault A default value (null QSize by default) returned if the
		 key was not found or if the read value cannot be interpreted.
				@return The value for this key.
   
		@short    Reads a QSize entry.
	*/
	public native QSize readSizeEntry(String pKey, QSize pDefault);
	public native QSize readSizeEntry(String pKey);
	/**	
		 Reads a QColor entry.
			 Read the value of an entry specified by <code>pKey</code> in the current group
		 and interpret it as a color.
			@param pKey The key to search for.
			@param pDefault A default value (null QColor by default) returned if the
		 key was not found or if the value cannot be interpreted.
				@return The value for this key.
   
		@short    Reads a QColor entry.
	*/
	public native QColor readColorEntry(String pKey, QColor pDefault);
	public native QColor readColorEntry(String pKey);
	/**	
		 Reads a Calendar entry.
			 Read the value of an entry specified by <code>pKey</code> in the current group
		 and interpret it as a date and time.
			@param pKey The key to search for.
			@param pDefault A default value ( currentDateTime() by default)
		 returned if the key was not found or if the read value cannot be
		 interpreted.
				@return The value for this key.
   
		@short    Reads a QDateTime entry.
	*/
	public native Calendar readDateTimeEntry(String pKey, Calendar pDefault);
	public native Calendar readDateTimeEntry(String pKey);
	/**	
		 Reads the value of an entry specified by <code>pKey</code> in the current group.
		 The untranslated entry is returned, you normally do not need this.
			@param pKey The key to search for.
			@param aDefault A default value returned if the key was not found.
				@return The value for this key.
   
		@short    Reads the value of an entry specified by <code>pKey</code> in the current group.
	*/
	public native String readEntryUntranslated(String pKey, String aDefault);
	public native String readEntryUntranslated(String pKey);
	/**	
		 Writes a key/value pair.
			 This is stored in the most specific config file when destroying the
		 config object or when calling sync().
			@param pKey The key to write.
			@param pValue The value to write.
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty
		                     flag will not be set and thus the entry will
		                     not be written to disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		                     application specific config file, but to the
		                     global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		                     when writing it back.
		   		@short    Writes a key/value pair.
	*/
	public native void writeEntry(String pKey, String pValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry(String pKey, String pValue, boolean bPersistent, boolean bGlobal);
	public native void writeEntry(String pKey, String pValue, boolean bPersistent);
	public native void writeEntry(String pKey, String pValue);
	/**	
		 writeEntry() Overridden to accept a property.
			 Note: Unlike the other writeEntry() functions, the old value is
		 _not_ returned here!
			@param pKey The key to write
			@param rValue The property to write
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty flag
		                    will not be set and thus the entry will not be
		                    written to disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		                    application specific config file, but to the
		                    global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		             when writing it back.
				@short    writeEntry() Overridden to accept a property.
		@see #writeEntry
	*/
	public native void writeEntry(String pKey, QVariant rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry(String pKey, QVariant rValue, boolean bPersistent, boolean bGlobal);
	public native void writeEntry(String pKey, QVariant rValue, boolean bPersistent);
	public native void writeEntry(String pKey, QVariant rValue);
	/**	
		 writeEntry() overridden to accept a list of strings.
			 Note: Unlike the other writeEntry() functions, the old value is
		 _not_ returned here!
			@param pKey The key to write
			@param rValue The list to write
			@param sep The list separator (default is ",").
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty flag
		                    will not be set and thus the entry will not be
		                    written to disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		                application specific config file, but to the
		                global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		             when writing it back.
				@short    writeEntry() overridden to accept a list of strings.
		@see #writeEntry
	*/
	public native void writeEntry(String pKey, String[] rValue, char sep, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry(String pKey, String[] rValue, char sep, boolean bPersistent, boolean bGlobal);
	public native void writeEntry(String pKey, String[] rValue, char sep, boolean bPersistent);
	public native void writeEntry(String pKey, String[] rValue, char sep);
	public native void writeEntry(String pKey, String[] rValue);
	/**	
		 writeEntry() overridden to accept a list of Integers.
			 Note: Unlike the other writeEntry() functions, the old value is
		 _not_ returned here!
			@param pKey The key to write
			@param rValue The list to write
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty flag
		                    will not be set and thus the entry will not be
		                    written to disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		                application specific config file, but to the
		                global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		             when writing it back.
				@short    writeEntry() overridden to accept a list of Integers.
		@see #writeEntry
	*/
	public native void writeEntry(String pKey, int[] rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry(String pKey, int[] rValue, boolean bPersistent, boolean bGlobal);
	public native void writeEntry(String pKey, int[] rValue, boolean bPersistent);
	public native void writeEntry(String pKey, int[] rValue);
	/**	
		 Write a (key/value) pair.
		 Same as above, but writes a numerical value.
			@param pKey The key to write.
			@param nValue The value to write.
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty
		 flag will not be set and thus the entry will not be written to
		 disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		                    application specific config file, but to the
		                    global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		                    when writing it back.
		   		@short    Write a (key/value) pair.
	*/
	public native void writeEntry(String pKey, int nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry(String pKey, int nValue, boolean bPersistent, boolean bGlobal);
	public native void writeEntry(String pKey, int nValue, boolean bPersistent);
	public native void writeEntry(String pKey, int nValue);
	/**	
		 Writes a (key/value) pair.
		 Same as above, but write a long numerical value.
			@param pKey The key to write.
			@param nValue The value to write.
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty
		 flag will not be set and thus the entry will not be written to
		 disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		  application specific config file, but to the global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		  when writing it back.
		   		@short    Writes a (key/value) pair.
	*/
	public native void writeEntry(String pKey, long nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry(String pKey, long nValue, boolean bPersistent, boolean bGlobal);
	public native void writeEntry(String pKey, long nValue, boolean bPersistent);
	public native void writeEntry(String pKey, long nValue);
	/**	
		 Writes a (key/value) pair.
		 Same as above, but writes a floating-point value.
			@param pKey The key to write.
			@param nValue The value to write.
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty
		 flag will not be set and thus the entry will not be written to
		 disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		  application specific config file, but to the global KDE config file.
			@param format <code>format</code> determines the format to which the value
		  is converted. Default is 'g'.
			@param precision <code>precision</code> sets the precision with which the
		  value is converted. Default is 6 as in String.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		  when writing it back.
		   		@short    Writes a (key/value) pair.
	*/
	public native void writeEntry(String pKey, double nValue, boolean bPersistent, boolean bGlobal, char format, int precision, boolean bNLS);
	public native void writeEntry(String pKey, double nValue, boolean bPersistent, boolean bGlobal, char format, int precision);
	public native void writeEntry(String pKey, double nValue, boolean bPersistent, boolean bGlobal, char format);
	public native void writeEntry(String pKey, double nValue, boolean bPersistent, boolean bGlobal);
	public native void writeEntry(String pKey, double nValue, boolean bPersistent);
	public native void writeEntry(String pKey, double nValue);
	/**	
		 Writes a (key/value) pair.
		 Same as above, but writes a booleanean value.
			@param pKey The key to write.
			@param bValue The value to write.
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty
		 flag will not be set and thus the entry will not be written to
		 disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		  application specific config file, but to the global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		  when writing it back.
		   		@short    Writes a (key/value) pair.
	*/
	public native void writeEntry(String pKey, boolean bValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry(String pKey, boolean bValue, boolean bPersistent, boolean bGlobal);
	public native void writeEntry(String pKey, boolean bValue, boolean bPersistent);
	public native void writeEntry(String pKey, boolean bValue);
	/**	
		 Writes a (key/value) pair.
		 Same as above, but writes a font value.
			@param pKey The key to write.
			@param rFont The font value to write.
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty
		 flag will not be set and thus the entry will not be written to
		 disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		  application specific config file, but to the global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		  when writing it back.
		   		@short    Writes a (key/value) pair.
	*/
	public native void writeEntry(String pKey, QFont rFont, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry(String pKey, QFont rFont, boolean bPersistent, boolean bGlobal);
	public native void writeEntry(String pKey, QFont rFont, boolean bPersistent);
	public native void writeEntry(String pKey, QFont rFont);
	/**	
		 Writes a (key/value) pair.
		 Same as above, but write a color entry.
			 Note: Unlike the other writeEntry() functions, the old value is
		 _not_ returned here!
			@param pKey The key to write.
			@param rColor The color value to write.
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty
		 flag will not be set and thus the entry will not be written to
		 disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		  application specific config file, but to the global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		  when writing it back.
		   		@short    Writes a (key/value) pair.
	*/
	public native void writeEntry(String pKey, QColor rColor, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry(String pKey, QColor rColor, boolean bPersistent, boolean bGlobal);
	public native void writeEntry(String pKey, QColor rColor, boolean bPersistent);
	public native void writeEntry(String pKey, QColor rColor);
	/**	
		 Writes a (key/value) pair.
		 Same as above, but writes a date and time entry.
			 Note: Unlike the other writeEntry() functions, the old value is
		 <b>not</b> returned here!
			@param pKey The key to write.
			@param rDateTime The date and time value to write.
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty
		 flag will not be set and thus the entry will not be written to
		 disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		  application specific config file, but to the global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		  when writing it back.
		   		@short    Writes a (key/value) pair.
	*/
	public native void writeEntry(String pKey, Calendar rDateTime, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry(String pKey, Calendar rDateTime, boolean bPersistent, boolean bGlobal);
	public native void writeEntry(String pKey, Calendar rDateTime, boolean bPersistent);
	public native void writeEntry(String pKey, Calendar rDateTime);
	/**	
		 Writes a (key/value) pair.
		 Same as above, but writes a rectangle.
			 Note: Unlike the other writeEntry() functions, the old value is
		 _not_ returned here!
			@param pKey The key to write.
			@param rValue The rectangle value to write.
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty
		 flag will not be set and thus the entry will not be written to
		 disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		  application specific config file, but to the global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		  when writing it back.
		   		@short    Writes a (key/value) pair.
	*/
	public native void writeEntry(String pKey, QRect rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry(String pKey, QRect rValue, boolean bPersistent, boolean bGlobal);
	public native void writeEntry(String pKey, QRect rValue, boolean bPersistent);
	public native void writeEntry(String pKey, QRect rValue);
	/**	
		 Writes a (key/value) pair.
		 Same as above, but writes a point.
			 Note: Unlike the other writeEntry() functions, the old value is
		 _not_ returned here!
			@param pKey The key to write.
			@param rValue The point value to write.
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty
		 flag will not be set and thus the entry will not be written to
		 disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		  application specific config file, but to the global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		  when writing it back.
		   		@short    Writes a (key/value) pair.
	*/
	public native void writeEntry(String pKey, QPoint rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry(String pKey, QPoint rValue, boolean bPersistent, boolean bGlobal);
	public native void writeEntry(String pKey, QPoint rValue, boolean bPersistent);
	public native void writeEntry(String pKey, QPoint rValue);
	/**	
		 Writes a (key/value) pair.
		 Same as above, but writes a size.
			 Note: Unlike the other writeEntry() functions, the old value is
		 _not_ returned here!
			@param pKey The key to write.
			@param rValue The size value to write.
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty
		 flag will not be set and thus the entry will not be written to
		 disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		  application specific config file, but to the global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		  when writing it back.
		   		@short    Writes a (key/value) pair.
	*/
	public native void writeEntry(String pKey, QSize rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry(String pKey, QSize rValue, boolean bPersistent, boolean bGlobal);
	public native void writeEntry(String pKey, QSize rValue, boolean bPersistent);
	public native void writeEntry(String pKey, QSize rValue);
	/**	
		 Writes a file path.
			 It is checked whether the path is located under $HOME. If so the
		 path is written out with the user's home-directory replaced with
		 $HOME. The path should be read back with readPathEntry()
			@param pKey The key to write.
			@param path The path to write.
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty
		 flag will not be set and thus the entry will not be written to
		 disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		  application specific config file, but to the global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		  when writing it back.
		   		@short    Writes a file path.
	*/
	public native void writePathEntry(String pKey, String path, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writePathEntry(String pKey, String path, boolean bPersistent, boolean bGlobal);
	public native void writePathEntry(String pKey, String path, boolean bPersistent);
	public native void writePathEntry(String pKey, String path);
	/**	
		 writePathEntry() overridden to accept a list of paths (strings).
			 It is checked whether the paths are located under $HOME. If so each of
		 the paths are written out with the user's home-directory replaced with
		 $HOME. The paths should be read back with readPathListEntry()
			@param pKey The key to write
			@param rValue The list to write
			@param sep The list separator (default is ",").
			@param bPersistent If <code>bPersistent</code> is false, the entry's dirty flag
		                    will not be set and thus the entry will not be
		                    written to disk at deletion time.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not saved to the
		                application specific config file, but to the
		                global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the locale tag is added to the key
		             when writing it back.
				@short    writePathEntry() overridden to accept a list of paths (strings).
		@see #writePathEntry
		@see #readPathListEntry
	*/
	public native void writePathEntry(String pKey, String[] rValue, char sep, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writePathEntry(String pKey, String[] rValue, char sep, boolean bPersistent, boolean bGlobal);
	public native void writePathEntry(String pKey, String[] rValue, char sep, boolean bPersistent);
	public native void writePathEntry(String pKey, String[] rValue, char sep);
	public native void writePathEntry(String pKey, String[] rValue);
	/**	
		 Deletes the entry specified by <code>pKey</code> in the current group.
			@param pKey The key to delete.
			@param bGlobal If <code>bGlobal</code> is true, the pair is not removed from the
		  application specific config file, but to the global KDE config file.
			@param bNLS If <code>bNLS</code> is true, the key with the locale tag is removed.
		   		@short    Deletes the entry specified by <code>pKey</code> in the current group.
	*/
	public native void deleteEntry(String pKey, boolean bNLS, boolean bGlobal);
	public native void deleteEntry(String pKey, boolean bNLS);
	public native void deleteEntry(String pKey);
	/**	
		 Deletes a configuration entry group
			 If the group is not empty and bDeep is false, nothing gets
		 deleted and false is returned.
		 If this group is the current group and it is deleted, the
		 current group is undefined and should be set with setGroup()
		 before the next operation on the configuration object.
			@param group The name of the group
			@param bDeep Specify whether non-empty groups should be completely
		        deleted (including their entries).
			@param bGlobal If <code>bGlobal</code> is true, the pair is not removed from the
		  application specific config file, but to the global KDE config file.
				@return If the group is not empty and bDeep is false,
         deleteGroup returns false.
   
		@short    Deletes a configuration entry group
	*/
	public native boolean deleteGroup(String group, boolean bDeep, boolean bGlobal);
	public native boolean deleteGroup(String group, boolean bDeep);
	public native boolean deleteGroup(String group);
	/**	
		 Turns on or off "dollar  expansion" (see KConfigBase introduction)
		  when reading config entries.
		 Dollar sign expansion is initially OFF.
			@param _bExpand Tf true, dollar expansion is turned on.
		   		@short    Turns on or off "dollar  expansion" (see KConfigBase introduction)   when reading config entries.
	*/
	public native void setDollarExpansion(boolean _bExpand);
	public native void setDollarExpansion();
	/**	
		 Returns whether dollar expansion is on or off.  It is initially OFF.
				@return true if dollar expansion is on.
   
		@short    Returns whether dollar expansion is on or off.
	*/
	public native boolean isDollarExpansion();
	/**	
		 Mark the config object as "clean," i.e. don't write dirty entries
		 at destruction time. If <code>bDeep</code> is false, only the global dirty
		 flag of the KConfig object gets cleared. If you then call
		 writeEntry() again, the global dirty flag is set again and all
		 dirty entries will be written at a subsequent sync() call.
			 Classes that derive from KConfigBase should override this
		 method and implement storage-specific behavior, as well as
		 calling the KConfigBase.rollback() explicitly in the initializer.
			@param bDeep If true, the dirty flags of all entries are cleared,
		        as well as the global dirty flag.
		   		@short    Mark the config object as "clean," i.
	*/
	public native void rollback(boolean bDeep);
	public native void rollback();
	/**	
		 Flushes all changes that currently reside only in memory
		 back to disk / permanent storage. Dirty configuration entries are
		 written to the most specific file available.
			 Asks the back end to flush out all pending writes, and then calls
		 rollback().  No changes are made if the object has <code>readOnly</code>
		 status.
			 You should call this from your destructor in derivative classes.
				@short    Flushes all changes that currently reside only in memory  back to disk / permanent storage.
		@see #rollback
		@see #isReadOnly
	*/
	public native void sync();
	/**	
		 Checks whether the config file has any dirty (modified) entries.
				@return true if the config file has any dirty (modified) entries.
   
		@short    Checks whether the config file has any dirty (modified) entries.
	*/
	public native boolean isDirty();
	/**	
		 Sets the config object's read-only status.
			@param _ro If true, the config object will not write out any
		        changes to disk even if it is destroyed or sync() is called.
			   		@short    Sets the config object's read-only status.
	*/
	public native void setReadOnly(boolean _ro);
	/**	
		 Returns the read-only status of the config object.
				@return The read-only status.
    
		@short    Returns the read-only status of the config object.
	*/
	public native boolean isReadOnly();
	/**	
		 Checks whether the key has an entry in the currently active group.
		 Use this to determine whether a key is not specified for the current
		 group (hasKey() returns false). Keys with null data are considered
		 nonexistent.
			@param key The key to search for.
				@return If true, the key is available.
   
		@short    Checks whether the key has an entry in the currently active group.
	*/
	public native boolean hasKey(String key);
	/**	
		 Returns a map (tree) of entries for all entries in a particular
		 group.  Only the actual entry string is returned, none of the
		 other internal data should be included.
			@param group A group to get keys from.
				@return A map of entries in the group specified, indexed by key.
         The returned map may be empty if the group is not found.

		@short    Returns a map (tree) of entries for all entries in a particular  group.
		@see org.kde.qt.QMap
	*/
	// QMap<QString, QString> entryMap(const QString& arg1); >>>> NOT CONVERTED
	/**	
		 Reparses all configuration files. This is useful for programs
		 that use stand alone graphical configuration tools. The base
		 method implemented here only clears the group list and then
		 appends the default group.
			 Derivative classes should clear any internal data structures and
		 then simply call parseConfigFiles() when implementing this
		 method.
				@short    Reparses all configuration files.
		@see #parseConfigFiles
	*/
	public native void reparseConfiguration();
	/**	
		 Checks whether this configuration file can be modified.
				@return whether changes may be made to this configuration file.
   
		@short    Checks whether this configuration file can be modified.
	*/
	public native boolean isImmutable();
	/**	
		 Checks whether it is possible to change the given group.
			@param group the group to check
				@return whether changes may be made to <code>group</code> in this configuration
 file.
   
		@short    Checks whether it is possible to change the given group.
	*/
	public native boolean groupIsImmutable(String group);
	/**	
		 Checks whether it is possible to change the given entry.
			@param key the key to check
				@return whether the entry <code>key</code> may be changed in the current group
 in this configuration file.
   
		@short    Checks whether it is possible to change the given entry.
	*/
	public native boolean entryIsImmutable(String key);
	/**	
		 Returns the state of the app-config object.
			 Possible return values
		 are NoAccess (the application-specific config file could not be
		 opened neither read-write nor read-only), ReadOnly (the
		 application-specific config file is opened read-only, but not
		 read-write) and ReadWrite (the application-specific config
		 file is opened read-write).
				@return the state of the app-config object
   
		@short    Returns the state of the app-config object.
		@see ConfigState
	*/
	public native int getConfigState();
	/**	
		 Check whether the config files are writable.
			@param warnUser Warn the user if the configuration files are not writable.
				@return Indicates that all of the configuration files used are writable.

		@short    Check whether the config files are writable.
	*/
	public native boolean checkConfigFilesWritable(boolean warnUser);
	/**	
		 When set, all readEntry and readXXXEntry calls return the system
		 wide (default) values instead of the user's preference.
		 This is off by default.
				@short    When set, all readEntry and readXXXEntry calls return the system  wide (default) values instead of the user's preference.
	*/
	public native void setReadDefaults(boolean b);
	/**	
				@return true if all readEntry and readXXXEntry calls return the system
 wide (default) values instead of the user's preference.

		@short
	*/
	public native boolean readDefaults();
	/**	
		 Reverts the entry with key <code>key</code> in the current group in the
		 application specific config file to either the system wide (default)
		 value or the value specified in the global KDE config file.
			 To revert entries in the global KDE config file, the global KDE config
		 file should be opened explicitly in a separate config object.
			@param key The key of the entry to revert.
				@short    Reverts the entry with key <code>key</code> in the current group in the  application specific config file to either the system wide (default)  value or the value specified in the global KDE config file.
	*/
	public native void revertToDefault(String key);
	/**	
		 Returns whether a default is specified for an entry in either the
		 system wide configuration file or the global KDE config file.
			 If an application uses a dynamically determined default value for
		 a certain entry, it may wish to make the following check before
		 writing back changes:
		 <pre>
		 if ( (value == dynamicDefault) && !config.hasDefault(key) )
		    revertToDefault(key)
		 else
		    writeEntry(key, value)
		 </pre>
			 This ensures that as long as the entry is not modified to differ
		 from the dynamically determined default, the application will
		 follow changes of the default.
			@param key The key of the entry to check.
				@short    Returns whether a default is specified for an entry in either the  system wide configuration file or the global KDE config file.
	*/
	public native boolean hasDefault(String key);
}
