/***************************************************************************
                            kde_NamedNodeMap.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_NAMEDNODEMAP
#define KDE_NAMEDNODEMAP

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Objects implementing the <code> NamedNodeMap </code> interface are
 used to represent collections of nodes that can be accessed by
 name. Note that <code> NamedNodeMap </code> does not inherit from
 <code> NodeList </code> ; <code> NamedNodeMap </code> s are not
 maintained in any particular order. Objects contained in an object
 implementing <code> NamedNodeMap </code> may also be accessed by an
 ordinal index, but this is simply to allow convenient enumeration
 of the contents of a <code> NamedNodeMap </code> , and does not
 imply that the DOM specifies an order to these Nodes.

 
 @short *
 Objects implementing the <code> NamedNodeMap </code> interface are
 used to represent collections of nodes that can be accessed by
 name.
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_NamedNodeMap * kde_new_NamedNodeMap();
kde_NamedNodeMap * kde_new_NamedNodeMap1(kde_NamedNodeMap* other);
void kde_del_NamedNodeMap( kde_NamedNodeMap* p );

/** *
 The number of nodes in the map. The range of valid child node
 indices is 0 to <code> length-1 </code> inclusive.

     
*/
unsigned long kde_NamedNodeMap_length(kde_NamedNodeMap* instPointer);

/** *
 Retrieves a node specified by name.

     
*/
kde_DOMNode* kde_NamedNodeMap_getNamedItem(kde_NamedNodeMap* instPointer,kde_DOMString* name);

/** *
 Adds a node using its <code> nodeName </code> attribute.

  As the <code> nodeName </code> attribute is used to derive the
 name which the node must be stored under, multiple nodes of
 certain types (those that have a "special" string value) cannot
 be stored as the names would clash. This is seen as preferable
 to allowing nodes to be aliased.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this <code>
 NamedNodeMap </code> is readonly.

  INUSE_ATTRIBUTE_ERR: Raised if <code> arg </code> is an <code>
 Attr </code> that is already an attribute of another <code>
 Element </code> object. The DOM user must explicitly clone
 <code> Attr </code> nodes to re-use them in other elements.

     
*/
kde_DOMNode* kde_NamedNodeMap_setNamedItem(kde_NamedNodeMap* instPointer,kde_DOMNode* arg);

/** *
 Removes a node specified by name. If the removed node is an
 <code> Attr </code> with a default value it is immediately
 replaced.

     
*/
kde_DOMNode* kde_NamedNodeMap_removeNamedItem(kde_NamedNodeMap* instPointer,kde_DOMString* name);

/** *
 Returns the <code> index </code> th item in the map. If <code>
 index </code> is greater than or equal to the number of nodes
 in the map, this returns <code> null </code> .

     
*/
kde_DOMNode* kde_NamedNodeMap_item(kde_NamedNodeMap* instPointer,unsigned long index);

/** *
 Introduced in DOM Level 2

 Retrieves a node specified by local name and namespace URI. HTML-only
 DOM implementations do not need to implement this method.

*/
kde_DOMNode* kde_NamedNodeMap_getNamedItemNS(kde_NamedNodeMap* instPointer,kde_DOMString* namespaceURI, kde_DOMString* localName);

/** *
 Introduced in DOM Level 2

 Adds a node using its namespaceURI and localName. If a node with that
 namespace URI and that local name is already present in this map, it is
 replaced by the new one.
 HTML-only DOM implementations do not need to implement this method.

 NO_MODIFICATION_ALLOWED_ERR: Raised if this map is readonly.

 INUSE_ATTRIBUTE_ERR: Raised if arg is an Attr that is already an
 attribute of another Element object. The DOM user must explicitly clone
 Attr nodes to re-use them in other elements.
     
*/
kde_DOMNode* kde_NamedNodeMap_setNamedItemNS(kde_NamedNodeMap* instPointer,kde_DOMNode* arg);

/** *
 Introduced in DOM Level 2

 Removes a node specified by local name and namespace URI. A removed
 attribute may be known to have a default value when this map contains
 the attributes attached to an element, as returned by the attributes
 attribute of the Node interface. If so, an attribute immediately appears
 containing the default value as well as the corresponding namespace URI,
 local name, and prefix when applicable.
 HTML-only DOM implementations do not need to implement this method.

 NO_MODIFICATION_ALLOWED_ERR: Raised if this map is readonly.
     
*/
kde_DOMNode* kde_NamedNodeMap_removeNamedItemNS(kde_NamedNodeMap* instPointer,kde_DOMString* namespaceURI, kde_DOMString* localName);

/** *

 not part of the DOM
     
*/

#ifdef __cplusplus
}
#endif
#endif
