/***************************************************************************
                            kde_KPushButton.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPUSHBUTTON
#define KDE_KPUSHBUTTON

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This is nothing but a QPushButton with drag-support and KGuiItem support. You have to call
 @ref setDragEnabled( true ) and override the virtual method
 @ref dragObject() to specify the QDragObject to be used.

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A QPushButton with drag-support and KGuiItem support.
*/

/** *
 Default constructor.
     
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KPushButton * kde_new_KPushButton(qt_QWidget * parent, char* name);

/** *
 Constructor, that sets the button-text to @p text
     
*/
kde_KPushButton * kde_new_KPushButton1(qt_QString * text, qt_QWidget * parent, char* name);

/** *
 Constructor, that sets an icon and the button-text to @p text
     
*/
kde_KPushButton * kde_new_KPushButton2(qt_QIconSet* icon, qt_QString * text, qt_QWidget * parent, char* name);

/** *
 Constructor that takes a KGuiItem for the text, the icon, the tooltip
 and the what's this help
     
*/
kde_KPushButton * kde_new_KPushButton3(kde_KGuiItem* item, qt_QWidget * parent, char* name);

/** *
 Destructs the button.
     
*/
void kde_del_KPushButton( kde_KPushButton* p );

/** *
 Enables/disables drag-support. Default is enabled.
     
*/
void kde_KPushButton_setDragEnabled(kde_KPushButton* instPointer,int enable);

/** *

*/
int kde_KPushButton_isDragEnabled(kde_KPushButton* instPointer);

/** *
 Sets the KGuiItem for this button.
     
*/
void kde_KPushButton_setGuiItem(kde_KPushButton* instPointer,kde_KGuiItem* item);

/** *
 Reimplement this and return the QDragObject that should be used
 for the drag.
 Default implementation returns 0L, so that no drag is initiated.
     
*/
qt_QDragObject* kde_KPushButton_dragObject(kde_KPushButton* instPointer);

/** *
 Reimplemented to add drag-support
     
*/

/** *
 Reimplemented to add drag-support
     
*/

/** *
 Starts a drag (dragCopy() by default) using @ref dragObject()
     
*/
void kde_KPushButton_startDrag(kde_KPushButton* instPointer);
void kde_KPushButton_virtual_hook(kde_KPushButton* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
