/***************************************************************************
                            kde_KPrinter.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPRINTER
#define KDE_KPRINTER

#include <qtc/qtc_types.h>
#include <qtc/qt_QPrinter.h>

#include <kdec/kde_types.h>

/**
*
 This class is the main interface to access the KDE print framework. It allows KDE
 applications to easily access the print system, through an interface that is compatible
 with @ref QPrinter. So that the porting of an existing application should be as easy as
 replacing any occurence of @ref QPrinter by KPrinter. However applications that explicitly
 used the @ref QPrintDialog class must be changed to the standard KPrinter way of accessing
 the print dialog.

 Basically, a KDE application will use the KPrinter object as a paint device, and will draw
 on it using @ref QPainter. In a standard application, the use of the KPrinter class will
 look like this:
 <pre>
 #include <kprinter.h>
 #include <qpainter.h>

 void MyClass::doPrint()
 {
   KPrinter printer;

   printer.setFullPage( true );

   if ( printer.setup( this ) )
   {
     QPainter painter;

     painter.begin( &printer );
     <do something>
     painter.end();
   }
 }
 </pre>

 The KPrinter interface also allows some more advanced possibilities, like the customization
 of the print dialog to integrate application specific print options. This is done by subclassing
 @ref KPrintDialogPage and adding the page using @ref addDialogPage().

 @author Michael Goffioul

 @short The central interface class to access the KDE print system.

*/
#define KPRINTER_CopiesPage	0x01
#define KPRINTER_FilesPage	0x02
#define KPRINTER_Custom	0x10
#define KPRINTER_ApplicationSide	0x01
#define KPRINTER_SystemSide	0x02
#define KPRINTER_Dialog	0x00
#define KPRINTER_StandAlone	0x01
#define KPRINTER_StandAlonePersistent	0x02
#define KPRINTER_AllPages	0x00
#define KPRINTER_OddPages	0x01
#define KPRINTER_EvenPages	0x02
#define KPRINTER_Collate	0x00
#define KPRINTER_Uncollate	0x01
#define KPRINTER_GrayScale	QPrinter::GrayScale
#define KPRINTER_Color	QPrinter::Color
#define KPRINTER_Portrait	QPrinter::Portrait
#define KPRINTER_Landscape	QPrinter::Landscape
#define KPRINTER_FirstPageFirst	QPrinter::FirstPageFirst
#define KPRINTER_LastPageFirst	QPrinter::LastPageFirst
#define KPRINTER_A4	QPrinter::A4
#define KPRINTER_B5	QPrinter::B5
#define KPRINTER_Letter	QPrinter::Letter
#define KPRINTER_Legal	QPrinter::Legal
#define KPRINTER_Executive	QPrinter::Executive
#define KPRINTER_A0	QPrinter::A0
#define KPRINTER_A1	QPrinter::A1
#define KPRINTER_A2	QPrinter::A2
#define KPRINTER_A3	QPrinter::A3
#define KPRINTER_A5	QPrinter::A5
#define KPRINTER_A6	QPrinter::A6
#define KPRINTER_A7	QPrinter::A7
#define KPRINTER_A8	QPrinter::A8
#define KPRINTER_A9	QPrinter::A9
#define KPRINTER_B0	QPrinter::B0
#define KPRINTER_B1	QPrinter::B1
#define KPRINTER_B10	QPrinter::B10
#define KPRINTER_B2	QPrinter::B2
#define KPRINTER_B3	QPrinter::B3
#define KPRINTER_B4	QPrinter::B4
#define KPRINTER_B6	QPrinter::B6
#define KPRINTER_B7	QPrinter::B7
#define KPRINTER_B8	QPrinter::B8
#define KPRINTER_B9	QPrinter::B9
#define KPRINTER_C5E	QPrinter::C5E
#define KPRINTER_Comm10E	QPrinter::Comm10E
#define KPRINTER_DLE	QPrinter::DLE
#define KPRINTER_Folio	QPrinter::Folio
#define KPRINTER_Ledger	QPrinter::Ledger
#define KPRINTER_Tabloid	QPrinter::Tabloid
#define KPRINTER_NPageSize	QPrinter::NPageSize

/** *
 Constructor. This also restores/saves the state from a previous KPrinter object created within
 the same application run, if @p restore is true. Setting @p restore to false may
 be useful if you want an independant/clean KPrinter object.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KPrinter * kde_new_KPrinter(int restore, int m);

/** *
 Destructor. This also saves the current KPrinter state for future printing.
	 
*/
void kde_del_KPrinter( kde_KPrinter* p );

/** *
 See @ref QPrinter::newPage().
	 
*/
int kde_KPrinter_newPage(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::abort().
	 
*/
int kde_KPrinter_abort(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::aborted(.)
	 
*/
int kde_KPrinter_aborted(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::outputToFile().
	 
*/
int kde_KPrinter_outputToFile(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::setOutputToFile().
	 
*/
void kde_KPrinter_setOutputToFile(kde_KPrinter* instPointer,int arg1);

/** *
 See @ref QPrinter::outputFileName().
	 
*/
qt_QString * kde_KPrinter_outputFileName(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::setOutputFileName().
	 
*/
void kde_KPrinter_setOutputFileName(kde_KPrinter* instPointer,qt_QString * arg1);

/** *
 See @ref QPrinter::docName().
	 
*/
qt_QString * kde_KPrinter_docName(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::setDocName().
	 
*/
void kde_KPrinter_setDocName(kde_KPrinter* instPointer,qt_QString * arg1);

/** *
 See @ref QPrinter::creator().
	 
*/
qt_QString * kde_KPrinter_creator(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::setCreator().
	 
*/
void kde_KPrinter_setCreator(kde_KPrinter* instPointer,qt_QString * arg1);

/** *
 See @ref QPrinter::fullPage().
	 
*/
int kde_KPrinter_fullPage(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::setFullPage().
	 
*/
void kde_KPrinter_setFullPage(kde_KPrinter* instPointer,int arg1);

/** *
 See @ref QPrinter::colorMode().
	 
*/
int kde_KPrinter_colorMode(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::setColorMode().
	 
*/
void kde_KPrinter_setColorMode(kde_KPrinter* instPointer,int arg1);

/** *
 See @ref QPrinter::numCopies().
	 
*/
int kde_KPrinter_numCopies(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::setNumCopies().
	 
*/
void kde_KPrinter_setNumCopies(kde_KPrinter* instPointer,int n);

/** *
 See @ref QPrinter::orientation().
	 
*/
int kde_KPrinter_orientation(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::setOrientation().
	 
*/
void kde_KPrinter_setOrientation(kde_KPrinter* instPointer,int arg1);

/** *
 See @ref QPrinter::pageOrder().
	 
*/
int kde_KPrinter_pageOrder(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::setPageOrder().
	 
*/
void kde_KPrinter_setPageOrder(kde_KPrinter* instPointer,int arg1);

/** *
 Returns the collate status of the current KPrinter.
	 
*/
int kde_KPrinter_collate(kde_KPrinter* instPointer);

/** *
 Sets the collate status for the current KPrinter to @p type.
	 
*/
void kde_KPrinter_setCollate(kde_KPrinter* instPointer,int type);

/** *
 See @ref QPrinter::minPage().
	 
*/
int kde_KPrinter_minPage(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::maxPage().
	 
*/
int kde_KPrinter_maxPage(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::setMinMax().
	 
*/
void kde_KPrinter_setMinMax(kde_KPrinter* instPointer,int arg1, int arg2);

/** *
 Returns the first page to be printed.

 should use @ref pageList() instead, which takes into account all options: collate,
 page order, ranges, page set, ...

*/
int kde_KPrinter_fromPage(kde_KPrinter* instPointer);

/** *
 Returns the last page to be printed.

 should use @ref pageList() instead, which takes into account all options: collate,
 page order, ranges, page set, ...

*/
int kde_KPrinter_toPage(kde_KPrinter* instPointer);

/** *
 Sets the first and last page to be printed. See @ref QPrinter::setFromTo().
	 
*/
void kde_KPrinter_setFromTo(kde_KPrinter* instPointer,int arg1, int arg2);

/** *
 See @ref QPrinter::pageSize().
	 
*/
int kde_KPrinter_pageSize(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::setPageSize().
	 
*/
void kde_KPrinter_setPageSize(kde_KPrinter* instPointer,int arg1);

/** *
 See @ref QPrinter::printerName().
	 
*/
qt_QString * kde_KPrinter_printerName(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::setPrinterName().
	 
*/
void kde_KPrinter_setPrinterName(kde_KPrinter* instPointer,qt_QString * arg1);

/** *
 Returns the print program as set by @ref setPrintProgram() or by the print dialog
 if a special printer has been selected.

*/
qt_QString * kde_KPrinter_printProgram(kde_KPrinter* instPointer);

/** *
 Sets the command line to use when printing. This function is useful
 when using a KPrinter object without the print dialog, to control what
 to print and how to do it. The command line may contain the following
 tags:

   prt.setOutputToFile( true );
   prt.setOutputFileName( filename );
   prt.setPrintProgram( "gs -sDEVICE=png256 -sPAPERSIZE=%psl -sOutputFile=%out %in" );

   QPainter painter( &prt );
   doPaint( &painter );
 }
 </pre>

*/
void kde_KPrinter_setPrintProgram(kde_KPrinter* instPointer,qt_QString * cmd);

/** *
 See @ref QPrinter::printerSelectionOption(). Unused.
	 
*/
qt_QString * kde_KPrinter_printerSelectionOption(kde_KPrinter* instPointer);

/** *
 See @ref QPrinter::setPrinterSelectionOption(). Unused
	 
*/
void kde_KPrinter_setPrinterSelectionOption(kde_KPrinter* instPointer,qt_QString * arg1);

/** *
 Returns the current page number.

*/
int kde_KPrinter_currentPage(kde_KPrinter* instPointer);

/** *
 Sets the current page number. This page number will be used if the user
 selected "current page" in the print dialog. This option will only be
 enabled if the application does page selection itself and the application
 has called @ref setCurrentPage() before opening the print dialog:
 <pre>
 MyClass::MyClass()
 {
   KPrinter::setPageSelection( KPrinter::ApplicationSide );
 }

 void MyClass::doPrint()
 {
   KPrinter printer;

   printer.setCurrentPage( mycurrentpage );
   if ( printer.setup( this ) )
   {
     QValueList<int> pages = printer.pageList();
     ...
   }
 }
 </pre>

*/
void kde_KPrinter_setCurrentPage(kde_KPrinter* instPointer,int p);

/** *
 Returns the page set of the current KPrinter object.
	 
*/
int kde_KPrinter_pageSet(kde_KPrinter* instPointer);

/** *
 Sets up the KPrinter object using the print dialog, returns true if the user clicked OK.

*/
int kde_KPrinter_setup(kde_KPrinter* instPointer,qt_QWidget * parent, qt_QString * caption, int forceExpand);

/** *
 See @ref QPrinter::margins().
	 
*/
qt_QSize * kde_KPrinter_margins(kde_KPrinter* instPointer);

/** *
 Not used yet.
	 
*/
void kde_KPrinter_setMargins(kde_KPrinter* instPointer,qt_QSize * m);

/** *
 Returns the real page size in points. Some print system (like CUPS) allows to customize the
 page size through printer description files (PPD). The size returned corresponds to this
 size.

*/
qt_QSize * kde_KPrinter_realPageSize(kde_KPrinter* instPointer);

/** *
 Sets the real page size. For internal use only.

*/
void kde_KPrinter_setRealPageSize(kde_KPrinter* instPointer,qt_QSize * p);
void kde_KPrinter_setRealDrawableArea(kde_KPrinter* instPointer,qt_QRect* r);
qt_QRect* kde_KPrinter_realDrawableArea(kde_KPrinter* instPointer);
void kde_KPrinter_margins1(kde_KPrinter* instPointer,unsigned int* top, unsigned int* left, unsigned int* bottom, unsigned int* right);

/** *
 Sets the KPrinter object to preview mode if @p on is true. In this mode, nothing will be
 printed but only a preview dialog will be popped up with the single "Close" action. Using
 this mode, any application can easily implement a preview action:
 <pre>
 void MyClass:doPreview()
 {
   KPrinter prt( false );
   prt.setPreviewOnly( true );

   QPainter painter( &prt );
   doPrint( &painter );
 }
 </pre>

*/
void kde_KPrinter_setPreviewOnly(kde_KPrinter* instPointer,int on);

/** *
 Returns the preview-only state for this KPrinter object.

*/
int kde_KPrinter_previewOnly(kde_KPrinter* instPointer);

/** *
 Set the resolution of the current KPrinter object. The resolution is given in DPI. This
 resolution mainly affects the accuracy for object positionning on the paint device, and
 does not influence the real resolution that will be used by the printer (this should be
 set in the driver settings). The resolution is usually defined in the constructor.

*/
void kde_KPrinter_setResolution(kde_KPrinter* instPointer,int dpi);

/** *
 Resturns the resolution of the current KPrinter object. The resolution is given in DPI.

*/
int kde_KPrinter_resolution(kde_KPrinter* instPointer);

/** *
 For internal use only.
	 
*/

/** *
 Prints the files given in argument. This will first filter the files accorsing to the filtering
 options selected by the user in the print dialog, then send the filtered files to the printer
 with the print options selected. This function is called automatically when calling
 @ref QPainter::end() for a painter object constructed on KPrinter. In normal use, you don't need
 this use this function explicitely.
	 
*/
int kde_KPrinter_printFiles(kde_KPrinter* instPointer,qt_QStringList* files, int removeafter, int startviewer);

/** *
 The KPrinter object stores all its settings in an internal @ref QMap structure on @ref
 QString. This allows to store any property. This method allows an application to access
 any print option from the KPrinter object, using the option name. For example if your
 application add a customized page to the print dialog, this page will saves its settings
 into the KPrinter object using this QMap<QString,QString> structure. After showing the
 print dialog, your application can then access these options using this method. The
 custom option name should follow the form "kde-appname-optionname".
 <pre>
 void MyClass::doPrint()
 {
   KPrinter prt;

   prt.addDialogPage( new MyDialogPage() );

   if ( prt.setup( this ) )
   {
      QString fntname = prt.option( "kde-myapp-fontname" );
      ...
      do_something;
      ...
   }
 }
 </pre>

*/
qt_QString * kde_KPrinter_option(kde_KPrinter* instPointer,qt_QString * key);

/** *
 Adds or modifies an option in the KPrinter object. You probably don't need to use this function
 explicitely. This will be done implicitely for example when reimplementing @ref
 KPrintDialogPage::getOptions().

*/
void kde_KPrinter_setOption(kde_KPrinter* instPointer,qt_QString * key, qt_QString * value);

/** *
 Returns the search name of the printer selected by the user. Each printer is identified by
 a unique name. This method is mainly used for state restoration. For internal use.

*/
qt_QString * kde_KPrinter_searchName(kde_KPrinter* instPointer);

/** *
 Sets the search name of the KPrinter object. For internal use.

*/
void kde_KPrinter_setSearchName(kde_KPrinter* instPointer,qt_QString * n);

/** *
 Returns the last error message issued by the print system. Unimplemented yet.

*/
qt_QString * kde_KPrinter_errorMessage(kde_KPrinter* instPointer);

/** *
 Sets the last error message. For internal use.

*/
void kde_KPrinter_setErrorMessage(kde_KPrinter* instPointer,qt_QString * msg);

/** *
 Configure the KPrinter object to be used with the printer named
 @p prname. After the call, the KPrinter object can be used without
 the need to call the print dialog. If @p prname is empty, then the
 KPrinter object is configured for the default printer. If @p prname
 corresponds to a pseudo-printer which needs an output file, a file
 dialog will be used. In that case, providing a parent widget for
 that dialog in @p parent may be useful.

*/
int kde_KPrinter_autoConfigure(kde_KPrinter* instPointer,qt_QString * prname, qt_QWidget * parent);

/** *
 Set the default document filename. This filename will be used as the
 default basename for the output file, instead of the default "print".
 For exmaple, by using setDocFileName("my_document"), the default
 output file will be $HOME/my_document.ps.

*/
void kde_KPrinter_setDocFileName(kde_KPrinter* instPointer,qt_QString * filename);

/** *
 Get the default document filename, that is the default basename used for
 the output file.

*/
qt_QString * kde_KPrinter_docFileName(kde_KPrinter* instPointer);

/** *
 Set the default document directory. This directory will be used as
 the default location for any output file. If not set, $HOME directory
 is used instead.

*/
void kde_KPrinter_setDocDirectory(kde_KPrinter* instPointer,qt_QString * dir);

/** *
 Get the default document directory, that is the directory used for
 any output file. By default, it is the $HOME directory.

*/
qt_QString * kde_KPrinter_docDirectory(kde_KPrinter* instPointer);

/** *
 Adds a customized page to the print dialog. The pages will appear in a tab widget in the
 bottom half of the dialog, along with the standard "Copies" page. The page must be created
 and added each time you want open a print dialog with @ref setup(). If you correctly
 reimplemented @ref KPrintDialogPage::setOptions(), the settings will be restored from call
 to call, you don't have to worry about state saving/restoration.

*/

/** *
 Sets the page selection mode of the application. If needed, call this method somewhere at
 the beginning of your code. The default value is @p SystemSide.

*/
void kde_KPrinter_setPageSelection( int arg1);

/** *
 Returns the page selection mode of the current application.

*/
int kde_KPrinter_pageSelection( );

/** *
 Sets the application type concerning the print dialog. You probably don't want to use it.
 For internal use only.

*/
void kde_KPrinter_setApplicationType( int type);

/** *
 Returns the application type concerning the print dialog. For internal use only.

*/
int kde_KPrinter_applicationType( );

/** *
 Adds a standard page to the print dialog. This is not useful yet as there's only one
 standard page defines @p CopiesPage.

*/
void kde_KPrinter_addStandardPage( int p);

/** *
 Removes a standard page from the print dialog. If your application doesn't want a
 standard page in the dialog, simply call this method with the correct identifier.
 By default, the print dialog includes the @p CopiesPage page.

*/
void kde_KPrinter_removeStandardPage( int p);
int kde_KPrinter_cmd(kde_KPrinter* instPointer,int arg1, qt_QPainter * arg2, qt_QPDevCmdParam* arg3);
int kde_KPrinter_metric(kde_KPrinter* instPointer,int arg1);
void kde_KPrinter_translateQtOptions(kde_KPrinter* instPointer);
void kde_KPrinter_loadSettings(kde_KPrinter* instPointer);
void kde_KPrinter_saveSettings(kde_KPrinter* instPointer);
void kde_KPrinter_preparePrinting(kde_KPrinter* instPointer);
void kde_KPrinter_finishPrinting(kde_KPrinter* instPointer);
void kde_KPrinter_reload(kde_KPrinter* instPointer);
void kde_KPrinter_init(kde_KPrinter* instPointer,int restore, int m);
int kde_KPrinter_doPreview(kde_KPrinter* instPointer,qt_QString * file);

/** Casts a 'kde_KPrinter *' to a 'kde_KPReloadObject*' */

/** Casts a 'kde_KPrinter *' to a 'qt_QPaintDevice *' */
qt_QPaintDevice * kde_KPrinter_QPaintDevice(kde_KPrinter* instPointer);

#ifdef __cplusplus
}
#endif
#endif
