/***************************************************************************
                            kde_KHTMLPart.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KHTMLPART
#define KDE_KHTMLPART

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This class is khtml's main class. It features an almost complete
 web browser, and html renderer.

 The easiest way to use this class (if you just want to display a an HTML
 page at some URL) is the following:

 <pre>
 KURL url = "http://www.kde.org";
 KHTMLPart *w = new KHTMLPart();
 w->openURL(url);
 w->view()->resize(500, 400);
 w->show();
 </pre>

 By default Java and JavaScript support are disabled. You can enable them by
 using the @ref setJavaEnabled() and @ref setJScriptEnabled() methods.

 Some apps want to write their HTML code directly into the widget instead of
 it opening an url. You can also do that in the following way:

 <pre>
 QString myHTMLCode = ...;
 KHTMLPart *w = new KHTMLPart();
 w->begin();
 w->write(myHTMLCode);
 ...
 w->end();
 </pre>

 You can do as many calls to write as you want. But there are two
 @ref write() methods, one accepting a @ref QString one accepting a
 @p char @p * argument. You should use one or the other
 (but not both) since the method using
 the @p char @p * argument does an additional decoding step to convert the
 written data to Unicode.

 @author Lars Knoll (knoll@kde.org)

 @version $Id: kde_KHTMLPart.h,v 1.7 2002/12/30 14:37:06 geiseri Exp $
 
 @short HTML Browser Widget.
*/
#define KHTMLPART_DefaultGUI	0
#define KHTMLPART_BrowserViewGUI	1

/** *
 Constructs a new KHTMLPart.

 KHTML basically consists of two objects: The KHTMLPart itself,
 holding the document data (DOM document), and the @ref KHTMLView,
 derived from @ref QScrollView, in which the document content is
 rendered in. You can specify two different parent objects for a
 KHTMLPart, one parent for the KHTMLPart document and on parent
 for the @ref KHTMLView. If the second @p parent argument is 0L, then
 @p parentWidget is used as parent for both objects, the part and
 the view.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KHTMLPart * kde_new_KHTMLPart(qt_QWidget * parentWidget, char* widgetname, qt_QObject * parent, char* name, int prof);
kde_KHTMLPart * kde_new_KHTMLPart1(kde_KHTMLView* view, qt_QObject * parent, char* name, int prof);

/** *
 Destructor.
   
*/
void kde_del_KHTMLPart( kde_KHTMLPart* p );

/** *
 Opens the specified URL @p url.

 Reimplemented from @ref KParts::ReadOnlyPart::openURL .
   
*/
int kde_KHTMLPart_openURL(kde_KHTMLPart* instPointer,kde_KURL* url);

/** *
 Stops loading the document and kill all data requests (for images, etc.)
   
*/
int kde_KHTMLPart_closeURL(kde_KHTMLPart* instPointer);

/** *
 is called when a certain error situation (i.e. connection timed out) occured.
 default implementation either shows a KIO error dialog or loads a more verbose
 error description a as page, depending on the users configuration.
 @p job is the job that signaled the error situation
   
*/
void kde_KHTMLPart_showError(kde_KHTMLPart* instPointer,kde_Job* job);

/** *
 Returns a reference to the DOM HTML document (for non-HTML documents, returns null)
   
*/
kde_HTMLDocument* kde_KHTMLPart_htmlDocument(kde_KHTMLPart* instPointer);

/** *
 Returns a reference to the DOM document.
   
*/
kde_DOMDocument* kde_KHTMLPart_document(kde_KHTMLPart* instPointer);

/** *
 Returns the node that has the keyboard focus.
   
*/
kde_DOMNode* kde_KHTMLPart_activeNode(kde_KHTMLPart* instPointer);

/** *
 Returns a pointer to the @ref KParts::BrowserExtension.
   
*/
kde_BrowserExtension* kde_KHTMLPart_browserExtension(kde_KHTMLPart* instPointer);

/** *
 Returns a pointer to the HTML document's view.
   
*/
kde_KHTMLView* kde_KHTMLPart_view(kde_KHTMLPart* instPointer);

/** *
 Enable/disable Javascript support. Note that this will
 in either case permanently override the default usersetting.
 If you want to have the default UserSettings, don't call this
 method.
   
*/
void kde_KHTMLPart_setJScriptEnabled(kde_KHTMLPart* instPointer,int enable);

/** *
 Returns @p true if Javascript support is enabled or @p false
 otherwise.
   
*/
int kde_KHTMLPart_jScriptEnabled(kde_KHTMLPart* instPointer);

/** *
 Enable/disable the automatic forwarding by <meta http-equiv="refresh" ....>
   
*/
void kde_KHTMLPart_setMetaRefreshEnabled(kde_KHTMLPart* instPointer,int enable);

/** *
 Returns @p true if automtaic forwarding is enabled.
   
*/
int kde_KHTMLPart_metaRefreshEnabled(kde_KHTMLPart* instPointer);

/** *
 Execute the specified snippet of JavaScript code.

 Returns @p true if JavaScript was enabled, no error occured
 and the code returned true itself or @p false otherwise.

   
*/
qt_QVariant * kde_KHTMLPart_executeScript(kde_KHTMLPart* instPointer,qt_QString * script);

/** *
 Same as above except the Node parameter specifying the 'this' value.
   
*/
qt_QVariant * kde_KHTMLPart_executeScript1(kde_KHTMLPart* instPointer,kde_DOMNode* n, qt_QString * script);

/** *
 Enables or disables Drag'n'Drop support. A drag operation is started if
 the users drags a link.
   
*/
void kde_KHTMLPart_setDNDEnabled(kde_KHTMLPart* instPointer,int b);

/** *
 Returns whether Dragn'n'Drop support is enabled or not.
   
*/
int kde_KHTMLPart_dndEnabled(kde_KHTMLPart* instPointer);

/** *
 Enables/disables Java applet support. Note that calling this function
 will permanently override the User settings about Java applet support.
 Not calling this function is the only way to let the default settings
 apply.
   
*/
void kde_KHTMLPart_setJavaEnabled(kde_KHTMLPart* instPointer,int enable);

/** *
 Return if Java applet support is enabled/disabled.
   
*/
int kde_KHTMLPart_javaEnabled(kde_KHTMLPart* instPointer);

/** *
 Returns the java context of the applets. If no applet exists, 0 is returned.
   
*/

/** *
 Returns the java context of the applets. If no context exists yet, a new one is
 created.
   
*/

/** *
 Enables or disables plugins via, default is enabled
   
*/
void kde_KHTMLPart_setPluginsEnabled(kde_KHTMLPart* instPointer,int enable);

/** *
 Returns trie if plugins are enabled/disabled.
   
*/
int kde_KHTMLPart_pluginsEnabled(kde_KHTMLPart* instPointer);

/** *
 Specifies whether images contained in the document should be loaded
 automatically or not.

 @note Request will be ignored if called before @ref begin().
   
*/
void kde_KHTMLPart_setAutoloadImages(kde_KHTMLPart* instPointer,int enable);

/** *
 Returns whether images contained in the document are loaded automatically
 or not.
 @note that the returned information is unrelieable as long as no begin()
 was called.
   
*/
int kde_KHTMLPart_autoloadImages(kde_KHTMLPart* instPointer);

/** *
 Security option.

 Specify whether only local references ( stylesheets, images, scripts, subdocuments )
 should be loaded. ( default false - everything is loaded, if the more specific
 options allow )
   
*/
void kde_KHTMLPart_setOnlyLocalReferences(kde_KHTMLPart* instPointer,int enable);

/** *
 Returnd whether references should be loaded ( default false )

*/
int kde_KHTMLPart_onlyLocalReferences(kde_KHTMLPart* instPointer);
void kde_KHTMLPart_enableJScript(kde_KHTMLPart* instPointer,int e);
void kde_KHTMLPart_enableJava(kde_KHTMLPart* instPointer,int e);
void kde_KHTMLPart_enablePlugins(kde_KHTMLPart* instPointer,int e);
void kde_KHTMLPart_autoloadImages1(kde_KHTMLPart* instPointer,int e);
void kde_KHTMLPart_enableMetaRefresh(kde_KHTMLPart* instPointer,int e);
int kde_KHTMLPart_setCharset(kde_KHTMLPart* instPointer,qt_QString * arg1, int arg2);
kde_KURL* kde_KHTMLPart_baseURL(kde_KHTMLPart* instPointer);
qt_QString * kde_KHTMLPart_baseTarget(kde_KHTMLPart* instPointer);

/** *
 Returns the URL for the background Image (used by save background)
   
*/
kde_KURL* kde_KHTMLPart_backgroundURL(kde_KHTMLPart* instPointer);

/** *
 Schedules a redirection after @p delay seconds.
   
*/
void kde_KHTMLPart_scheduleRedirection(kde_KHTMLPart* instPointer,int delay, qt_QString * url, int lockHistory);

/** *
 Clears the widget and prepares it for new content.

 If you want @ref url() to return
 for example "file:/tmp/test.html", you can use the following code:
 <PRE>
 view->begin( KURL("file:/tmp/test.html" ) );
 </PRE>

 All child frames and the old document are removed if you call
 this method.
   
*/
void kde_KHTMLPart_begin(kde_KHTMLPart* instPointer,kde_KURL* url, int xOffset, int yOffset);

/** *
 Writes another part of the HTML code to the widget.

 You may call
 this function many times in sequence. But remember: The fewer calls
 you make, the faster the widget will be.

 The HTML code is send through a decoder which decodes the stream to
 Unicode.

 The @p len parameter is needed for streams encoded in utf-16,
 since these can have \0 chars in them. In case the encoding
 you're using isn't utf-16, you can safely leave out the length
 parameter.

 Attention: Don't mix calls to @ref write( const char *) with calls
 to @ref write( const QString & ).

 The result might not be what you want.
   
*/
void kde_KHTMLPart_write(kde_KHTMLPart* instPointer,char* str, int len);

/** *
 Writes another part of the HTML code to the widget.

 You may call
 this function many times in sequence. But remember: The fewer calls
 you make, the faster the widget will be.
   
*/
void kde_KHTMLPart_write1(kde_KHTMLPart* instPointer,qt_QString * str);

/** *
 Call this after your last call to @ref write().
   
*/
void kde_KHTMLPart_end(kde_KHTMLPart* instPointer);

/** *
 Paints the HTML page to a QPainter. See @ref KHTMLView::paint for details
   
*/
void kde_KHTMLPart_paint(kde_KHTMLPart* instPointer,qt_QPainter * arg1, qt_QRect* arg2, int arg3, int* arg4);

/** *
 Sets the encoding the page uses.

 This can be different from the charset. The widget will try to reload the current page in the new
 encoding, if url() is not empty.
   
*/
int kde_KHTMLPart_setEncoding(kde_KHTMLPart* instPointer,qt_QString * name, int override);

/** *
 Returns the encoding the page currently uses.

 Note that the encoding might be different from the charset.
   
*/
qt_QString * kde_KHTMLPart_encoding(kde_KHTMLPart* instPointer);

/** *
 Sets a user defined style sheet to be used on top of the HTML 4
 default style sheet.

 This gives a wide range of possibilities to
 change the layout of the page.
   
*/
void kde_KHTMLPart_setUserStyleSheet(kde_KHTMLPart* instPointer,kde_KURL* url);

/** *
 Sets a user defined style sheet to be used on top of the HTML 4
 default style sheet.

 This gives a wide range of possibilities to
 change the layout of the page.
   
*/
void kde_KHTMLPart_setUserStyleSheet1(kde_KHTMLPart* instPointer,qt_QString * styleSheet);

/** *
 Sets the standard font style.

*/
void kde_KHTMLPart_setStandardFont(kde_KHTMLPart* instPointer,qt_QString * name);

/** *
 Sets the fixed font style.

*/
void kde_KHTMLPart_setFixedFont(kde_KHTMLPart* instPointer,qt_QString * name);

/** *
 Finds the anchor named @p name.

 If the anchor is found, the widget
 scrolls to the closest position. Returns @p if the anchor has
 been found.
   
*/
int kde_KHTMLPart_gotoAnchor(kde_KHTMLPart* instPointer,qt_QString * name);

/** *
 Sets the cursor to use when the cursor is on a link.
   
*/
void kde_KHTMLPart_setURLCursor(kde_KHTMLPart* instPointer,qt_QCursor * c);

/** *
 Returns the cursor which is used when the cursor is on a link.
   
*/
qt_QCursor* kde_KHTMLPart_urlCursor(kde_KHTMLPart* instPointer);

/** *
 Initiates a text search.
   
*/
void kde_KHTMLPart_findTextBegin(kde_KHTMLPart* instPointer);

/** *
 Finds the next occurence of the string or expression.
 If isRegExp is true then str is converted to a QRegExp, and caseSensitive is ignored.
   
*/
int kde_KHTMLPart_findTextNext(kde_KHTMLPart* instPointer,qt_QString * str, int forward, int caseSensitive, int isRegExp);

/** *
 Sets the Zoom factor. The value is given in percent, larger values mean a
 generally larger font and larger page contents. It is not guaranteed that
 all parts of the page are scaled with the same factor though.

 The given value should be in the range of 20..300, values outside that
 range are not guaranteed to work. A value of 100 will disable all zooming
 and show the page with the sizes determined via the given lengths in the
 stylesheets.
   
*/
void kde_KHTMLPart_setZoomFactor(kde_KHTMLPart* instPointer,int percent);

/** *
 Returns the current zoom factor.
   
*/
int kde_KHTMLPart_zoomFactor(kde_KHTMLPart* instPointer);

/** *
 Returns the text the user has marked.
   
*/
qt_QString * kde_KHTMLPart_selectedText(kde_KHTMLPart* instPointer);

/** *
 Returns the selected part of the HTML.
   
*/
kde_Range* kde_KHTMLPart_selection(kde_KHTMLPart* instPointer);

/** *
 Sets the current selection.
   
*/

/** *
 Has the user selected anything?

  Call @ref selectedText() to
 retrieve the selected text.

*/
int kde_KHTMLPart_hasSelection(kde_KHTMLPart* instPointer);

/** *
 Marks all text in the document as selected.
   
*/
void kde_KHTMLPart_selectAll(kde_KHTMLPart* instPointer);

/** *
 Convenience method to show the document's view.

 Equivalent to widget()->show() or view()->show() .
   
*/
void kde_KHTMLPart_show(kde_KHTMLPart* instPointer);

/** *
 Convenience method to hide the document's view.

 Equivalent to widget()->hide() or view()->hide().
   
*/
void kde_KHTMLPart_hide(kde_KHTMLPart* instPointer);

/** *
 Returns a reference to the partmanager instance which
 manages html frame objects.
   
*/
kde_PartManager* kde_KHTMLPart_partManager(kde_KHTMLPart* instPointer);

/** *
 Saves the KHTMLPart's complete state (including child frame
 objects) to the provided @ref QDataStream.

 This is called from the @ref saveState() method of the
  @ref browserExtension().
   
*/
void kde_KHTMLPart_saveState(kde_KHTMLPart* instPointer,qt_QDataStream * stream);

/** *
 Restores the KHTMLPart's previously saved state (including
 child frame objects) from the provided QDataStream.

 This is called from the @ref restoreState() method of the
 @ref browserExtension() .

*/
void kde_KHTMLPart_restoreState(kde_KHTMLPart* instPointer,qt_QDataStream * stream);

/** *
 Returns the @p Node currently under the mouse
   
*/
kde_DOMNode* kde_KHTMLPart_nodeUnderMouse(kde_KHTMLPart* instPointer);

/** *

   
*/
kde_KHTMLSettings* kde_KHTMLPart_settings(kde_KHTMLPart* instPointer);

/** *
 Returns a pointer to the parent KHTMLPart if the part is a frame
 in an HTML frameset.

  Returns 0L otherwise.
   
*/
kde_KHTMLPart* kde_KHTMLPart_parentPart(kde_KHTMLPart* instPointer);

/** *
 Returns a list of names of all frame (including iframe) objects of
 the current document. Note that this method is not working recursively
 for sub-frames.
   
*/
qt_QStringList* kde_KHTMLPart_frameNames(kde_KHTMLPart* instPointer);

/** *
 Finds a frame by name. Returns 0L if frame can't be found.
   
*/
kde_KHTMLPart* kde_KHTMLPart_findFrame(kde_KHTMLPart* instPointer,qt_QString * f);

/** *
 Return the current frame (the one that has focus)
 Not necessarily a direct child of ours, framesets can be nested.
 Returns "this" if this part isn't a frameset.
   
*/
kde_ReadOnlyPart* kde_KHTMLPart_currentFrame(kde_KHTMLPart* instPointer);

/** *
 Returns whether a frame with the specified name is exists or not.
 In contrary to the @ref findFrame method this one also returns true
 if the frame is defined but no displaying component has been
 found/loaded, yet.
   
*/
int kde_KHTMLPart_frameExists(kde_KHTMLPart* instPointer,qt_QString * frameName);

/** *
 Called by KJS.
 Sets the StatusBarText assigned
 via window.status
   
*/
void kde_KHTMLPart_setJSStatusBarText(kde_KHTMLPart* instPointer,qt_QString * text);

/** *
 Called by KJS.
 Sets the DefaultStatusBarText assigned
 via window.defaultStatus
   
*/
void kde_KHTMLPart_setJSDefaultStatusBarText(kde_KHTMLPart* instPointer,qt_QString * text);

/** *
 Called by KJS.
 Returns the StatusBarText assigned
 via window.status
   
*/
qt_QString * kde_KHTMLPart_jsStatusBarText(kde_KHTMLPart* instPointer);

/** *
 Called by KJS.
 Returns the DefaultStatusBarText assigned
 via window.defaultStatus
   
*/
qt_QString * kde_KHTMLPart_jsDefaultStatusBarText(kde_KHTMLPart* instPointer);

/** *
 Referrer used for links in this page.
   
*/
qt_QString * kde_KHTMLPart_referrer(kde_KHTMLPart* instPointer);

/** *
 Last-modified date (in raw string format), if received in the [HTTP] headers.
   
*/
qt_QString * kde_KHTMLPart_lastModified(kde_KHTMLPart* instPointer);

/** *
 Loads a style sheet into the stylesheet cache.
   
*/
void kde_KHTMLPart_preloadStyleSheet(kde_KHTMLPart* instPointer,qt_QString * url, qt_QString * stylesheet);

/** *
 Loads a script into the script cache.
   
*/
void kde_KHTMLPart_preloadScript(kde_KHTMLPart* instPointer,qt_QString * url, qt_QString * script);

/** *

   
*/
int kde_KHTMLPart_restored(kde_KHTMLPart* instPointer);

/** *
 Sets the focussed node of the document to the specified node. If the node is a form control, the control will
 receive focus in the same way that it would if the user had clicked on it or tabbed to it with the keyboard. For
 most other types of elements, there is no visul indiction of whether or not they are focussed.

 See @ref activeNode

*/
void kde_KHTMLPart_setActiveNode(kde_KHTMLPart* instPointer,kde_DOMNode* node);

/** *
 Stops all animated images on the current and child pages
   
*/
void kde_KHTMLPart_stopAnimations(kde_KHTMLPart* instPointer);
qt_QCString* kde_KHTMLPart_dcopObjectId(kde_KHTMLPart* instPointer);

#ifdef __cplusplus
}
#endif
#endif
