/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.exslt;

import com.icl.saxon.Context;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.sort.NodeOrderComparer;
import java.util.Vector;

public abstract class Math {
    public static double max(NodeEnumeration nodeEnumeration) throws XPathException {
        double d = Double.NEGATIVE_INFINITY;
        while (nodeEnumeration.hasMoreElements()) {
            double d2 = Value.stringToNumber(nodeEnumeration.nextElement().getStringValue());
            if (Double.isNaN(d2)) {
                return d2;
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double min(NodeEnumeration nodeEnumeration) throws XPathException {
        double d = Double.POSITIVE_INFINITY;
        while (nodeEnumeration.hasMoreElements()) {
            double d2 = Value.stringToNumber(nodeEnumeration.nextElement().getStringValue());
            if (Double.isNaN(d2)) {
                return d2;
            }
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static NodeSetValue highest(Context context, NodeEnumeration nodeEnumeration) throws XPathException {
        double d = Double.NEGATIVE_INFINITY;
        Vector<NodeInfo> vector = new Vector<NodeInfo>();
        while (nodeEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = nodeEnumeration.nextElement();
            double d2 = Value.stringToNumber(nodeInfo.getStringValue());
            if (Double.isNaN(d2)) {
                return new EmptyNodeSet();
            }
            if (d2 == d) {
                vector.addElement(nodeInfo);
                continue;
            }
            if (!(d2 > d)) continue;
            d = d2;
            vector.removeAllElements();
            vector.addElement(nodeInfo);
        }
        return new NodeSetExtent(vector, (NodeOrderComparer)context.getController());
    }

    public static NodeSetValue lowest(Context context, NodeEnumeration nodeEnumeration) throws XPathException {
        double d = Double.POSITIVE_INFINITY;
        Vector<NodeInfo> vector = new Vector<NodeInfo>();
        while (nodeEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = nodeEnumeration.nextElement();
            double d2 = Value.stringToNumber(nodeInfo.getStringValue());
            if (Double.isNaN(d2)) {
                return new EmptyNodeSet();
            }
            if (d2 == d) {
                vector.addElement(nodeInfo);
                continue;
            }
            if (!(d2 < d)) continue;
            d = d2;
            vector.removeAllElements();
            vector.addElement(nodeInfo);
        }
        return new NodeSetExtent(vector, (NodeOrderComparer)context.getController());
    }
}

