/*****************************************************************

Copyright (c) 2001 Matthias Elter <elter@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qlayout.h>

#include <kapp.h>
#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>

#include "taskbarcontainer.h"

#include "taskbarapplet.h"
#include "taskbarapplet.moc"

extern "C"
{
    KPanelApplet* init( QWidget *parent, const QString& configFile )
    {
        KGlobal::locale()->insertCatalogue( "ktaskbarapplet" );
        int options = 0;
        if (kapp->authorizeControlModule("kde-kcmtaskbar.desktop"))
           options = KPanelApplet::Preferences;
        TaskbarApplet *taskbar = new TaskbarApplet( configFile, KPanelApplet::Stretch,
                                                    options, parent, "ktaskbarapplet" );
	return taskbar;
    }
}

TaskbarApplet::TaskbarApplet( const QString& configFile, Type type, int actions,
                             QWidget *parent, const char *name )
    : KPanelApplet( configFile, type, actions, parent, name )
{
    setBackgroundOrigin( AncestorOrigin );
    QHBoxLayout* layout = new QHBoxLayout( this );
    container = new TaskBarContainer( false, this );
    container->setBackgroundOrigin( AncestorOrigin );
    layout->addWidget( container, 1 );
}

TaskbarApplet::~TaskbarApplet()
{
    KGlobal::locale()->removeCatalogue( "ktaskbarapplet" );
}

int TaskbarApplet::widthForHeight( int ) const
{
    return 200;
}

int TaskbarApplet::heightForWidth( int ) const
{
    return 200;
}

void TaskbarApplet::preferences()
{
    container->preferences();
}

void TaskbarApplet::orientationChange( Orientation o )
{
    container->orientationChange( o );
}

void TaskbarApplet::popupDirectionChange( Direction d )
{
    container->popupDirectionChange( d );
}
