dnl= ##########################################################################
dnl= # abiword-plugins: autogen.sh header
dnl= # this file is executed as a shell script
dnl= 
dnl= # 1. abi_plugin_macro is the name of the main macro defined here:
dnl= abi_plugin_macro="ABIPGN_DOCBOOK"
dnl= abi_plugin_macro_init="ABIPGN_DOCBOOK_INIT"
dnl= abi_plugin_macro_end="ABIPGN_DOCBOOK_END"
dnl= 
dnl= # 2. abi_plugin_files is the list of files that configure must generate:
dnl= abi_plugin_files="GNUmakefile xp/GNUmakefile"
dnl= 
dnl= # 3. abi_plugin_desc is a short description of the plugin
dnl= abi_plugin_desc="Plain DocBook and DocBook with Coquille header extension, see http://www.infobi.com/dtd/coquille.dtd"
dnl=
dnl= # 4. abi_plugin_enable - whether plugin should be enabled by default 
dnl= abi_plugin_enable="yes"
dnl=
dnl= return
dnl= ##########################################################################

AC_DEFUN([ABIPGN_DOCBOOK_INIT],[

coquille_disable=no

AC_ARG_ENABLE(coquille,[  --disable-coquille],[
	if test "x$enableval" = "xno"; then
		coquille_disable=yes
	fi
])
AC_ARG_WITH(coquille,[  --without-coquille],[
	if test "x$withval" = "xno"; then
		coquille_disable=yes
	else
		coquille_disable=no
	fi
])

])

AC_DEFUN([ABIPGN_DOCBOOK],[

AC_HEADER_TIME

ABI_DOCBOOK_CPPFLAGS=""
ABI_DOCBOOK_LDFLAGS=""

if test $coquille_disable != yes; then
	ABI_DOCBOOK_CPPFLAGS="-DDOCBOOK_COQUILLE=1"
fi

AC_SUBST(ABI_DOCBOOK_CPPFLAGS)
AC_SUBST(ABI_DOCBOOK_LDFLAGS)

])

AC_DEFUN([ABIPGN_DOCBOOK_END],[

AM_CONDITIONAL(ABI_DOCBOOK_COQUILLE,[test $coquille_disable != yes])

])
