/*
 * Tlf - contest logging program for amateur radio operators
 * Copyright (C) 2001-2002-2003 Rein Couperus <pa0rct@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "sendqrg.h"
#include <stdlib.h>
#include <curses.h>

int sendqrg (void) {

extern char hiscall[];
extern int trx_control;
#ifdef HAVE_LIBHAMLIB
extern RIG *my_rig;
extern freq_t outfreq;
#else
extern int outfreq;
#endif

float trxqrg;


if (trx_control != 1)
	return(0);                  /* nothing to do here */

trxqrg = atof(hiscall);

switch ((int)trxqrg) {

	case 0 ... 1799 : {
		trxqrg = 0;
		break;
	}
	case 1800 ... 2000:
	case 3500 ... 4000:
	case 7000 ... 7300:
	case 10100 ... 10150:
	case 14000 ... 14350:
	case 18068 ... 18168:
	case 21000 ... 21450:
	case 24890 ... 24990:
	case 28000 ... 29700:
	{
#ifdef HAVE_LIBHAMLIB
		outfreq = (freq_t)(trxqrg*1000);
#else
		outfreq = (int)(trxqrg*1000);
#endif

		break;
	}
	default:
		trxqrg = 0;

}

 return(trxqrg);
}

/********************************************************************************************/
#ifdef HAVE_LIBHAMLIB                                       //code for Hamlib interface

int init_tlf_rig (void)
{
	extern RIG *my_rig;
	extern rig_model_t myrig_model;
	extern freq_t rigfreq;		/* frequency  */
	extern freq_t outfreq;
	extern rmode_t rmode;		/* radio mode of operation */
	extern  pbwidth_t width;
	extern vfo_t vfo;		/* vfo selection */
	extern port_t myport;
	extern int serial_rate;
	extern int rig_port;
	extern int verbose;
	extern int debugflag;

	int retcode;		/* generic return code from functions */

	const char *rig_file=NULL, *ptt_file=NULL, *dcd_file=NULL;
	ptt_type_t ptt_type = RIG_PTT_NONE;
	dcd_type_t dcd_type = RIG_DCD_NONE;

 	/*
	 * allocate memory, setup & open port
	 */
			rig_set_debug(RIG_DEBUG_NONE);

			my_rig = rig_init(myrig_model);

			if (!my_rig) {
				mvprintw(6,0, "Unknown rig num %d, or initialization error. ",  myrig_model);
				refresh();
				 sleep(2);
				return(-1);
			}

			if (rig_file) {
				if (rig_port == 0)
					strncpy(my_rig->state.rigport.pathname, "/dev/ttyS0", FILPATHLEN);
				else
					strncpy(my_rig->state.rigport.pathname, "/dev/ttyS1", FILPATHLEN);

			}

			if (ptt_type != RIG_PTT_NONE)
				my_rig->state.pttport.type.ptt = ptt_type;
			if (dcd_type != RIG_DCD_NONE)
				my_rig->state.dcdport.type.dcd = dcd_type;
			if (ptt_file)
				strncpy(my_rig->state.pttport.pathname, ptt_file, FILPATHLEN);
			if (dcd_file)
				strncpy(my_rig->state.dcdport.pathname, dcd_file, FILPATHLEN);
//serial_rate = 2400;
			my_rig->state.rigport.parm.serial.rate = serial_rate ;

			retcode = rig_open(my_rig);

			if (retcode != RIG_OK) {
	  			mvprintw(7,0,"rig_open: error = %s \n", rigerror(retcode));
				refresh();
				sleep(2);
				return(-1);
			}

			 retcode = rig_get_freq(my_rig, RIG_VFO_CURR, &rigfreq);

			if (retcode != RIG_OK)  {
				mvprintw(8,0,"Problem with rig link!\n");
				refresh();
				sleep(1);
			} else {
				 mvprintw(8,0,"freq = %lld, o.k!!!\n",rigfreq);
				refresh();
				if (verbose == 1) sleep(1);
			 }
if (debugflag == 1){			// debug routines
			 sleep(10);
			 
			 retcode = rig_get_freq(my_rig, RIG_VFO_CURR, &rigfreq);

			if (retcode != RIG_OK)  {
				mvprintw(9,0,"Problem with rig get freq!\n");
				refresh();
				sleep(1);
			} else {
				 mvprintw(9,0,"freq = %lld, o.k!!!\n",rigfreq);
				refresh();
				if (verbose == 1) sleep(1);
			 }
			 sleep(10);


			 outfreq = 14000000;	//test set frequency

			 retcode = rig_set_freq(my_rig, RIG_VFO_CURR, outfreq);

			if (retcode != RIG_OK)  {
				mvprintw(10,0,"Problem with rig set freq!\n");
				refresh();
				sleep(1);
			}else {
				mvprintw(10,0,"Rig set freq ok!\n");
				refresh();
				sleep(1);

			}

			outfreq = 0;
			 
			 retcode = rig_get_freq(my_rig, RIG_VFO_CURR, &rigfreq);	// read qrg

			if (retcode != RIG_OK)  {
				mvprintw(11,0,"Problem with rig get freq!\n");
				refresh();
				sleep(1);
			} else {
				 mvprintw(11,0,"freq = %lld, o.k!!!\n",rigfreq);
				refresh();
				if (verbose == 1) sleep(1);
			 }
			 sleep(10);


} // end debug

 if (verbose == 1 || debugflag ==1) sleep(1);

	return(0);
}

int close_tlf_rig(RIG *my_rig) {

	rig_close(my_rig); /* close port */
	rig_cleanup(my_rig); /* if you care about memory */

	printf("port %s closed ok \n",SERIAL_PORT);

return(0);
}

#endif         // end code for Hamlib interface
