/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io;

import com.sun.cdc.io.ConnectionBaseAdapter;
import java.io.IOException;

public abstract class BufferedConnectionAdapter
extends ConnectionBaseAdapter {
    protected boolean eof;
    protected byte[] buf;
    protected int count;
    protected int pos;

    protected BufferedConnectionAdapter(int n) {
        if (n > 0) {
            this.buf = new byte[n];
        }
    }

    public int readBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.count == 0) {
            if (this.eof) {
                return -1;
            }
            if (this.buf == null || n2 >= this.buf.length) {
                return this.nonBufferedRead(byArray, n, n2);
            }
            int n3 = this.nonBufferedRead(this.buf, 0, this.buf.length);
            this.pos = 0;
            if (n3 <= 0) {
                return n3;
            }
            this.count = n3;
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.count -= n2;
        this.pos += n2;
        return n2;
    }

    protected int readBytesNonBlocking(byte[] byArray, int n, int n2) throws IOException {
        return 0;
    }

    public int available() throws IOException {
        if (this.buf == null) {
            return 0;
        }
        if (this.count > 0) {
            return this.count;
        }
        int n = this.readBytesNonBlocking(this.buf, 0, this.buf.length);
        if (n == -1) {
            return 0;
        }
        this.pos = 0;
        this.count = n;
        return this.count;
    }

    protected abstract int nonBufferedRead(byte[] var1, int var2, int var3) throws IOException;
}

