/*
 * @(#)IClassMetaDataReaderUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.datastore;

import java.io.IOException;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.junit.v1.iftc.ImplFactory;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestCase;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestSuite;


/**
 * Tests the IClassMetaDataReader interface.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:28 $
 * @since     December 28, 2002
 */
public class IClassMetaDataReaderUTestI extends InterfaceTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = IClassMetaDataReaderUTestI.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public IClassMetaDataReaderUTestI( String name, ImplFactory f )
    {
        super( name, IClassMetaDataReader.class, f );
    }

    
    public IClassMetaDataReader createIClassMetaDataReader()
    {
        return (IClassMetaDataReader)createImplObject();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testGetClassSignatures1() throws Exception
    {
        IClassMetaDataReader cmdr = createIClassMetaDataReader();
        String sigs1[] = cmdr.getClassSignatures();
        assertNotNull(
            "Returned null sigs.",
            sigs1 );
        String sigs2[] = cmdr.getClassSignatures();
        assertNotNull(
            "Returned null sigs on second attempt.",
            sigs2 );
        assertEquals(
            "Two consecutive calls returned different class signatures.",
            sigs1.length,
            sigs2.length );
    }
    
    
    public void testGetClassSignatures2() throws Exception
    {
        IClassMetaDataReader cmdr = createIClassMetaDataReader();
        cmdr.close();
        try
        {
            cmdr.getClassSignatures();
            fail( "Did not throw IOException." );
        }
        catch (IOException ioe)
        {
            assertNotNull( "Null exception message.", ioe.getMessage() );
        }
    }
    
    
    public void testGetClassSignatures3() throws Exception
    {
        IClassMetaDataReader cmdr = createIClassMetaDataReader();
        String sigs1[] = cmdr.getClassSignatures();
        cmdr.close();
        try
        {
            cmdr.getClassSignatures();
            fail( "Did not throw IOException." );
        }
        catch (IOException ioe)
        {
            assertNotNull( "Null exception message.", ioe.getMessage() );
        }
    }
    
    
    public void testGetClassSignatures4() throws Exception
    {
        IClassMetaDataReader cmdr = createIClassMetaDataReader();
        String sigs[] = cmdr.getClassSignatures();
        for (int i = 0; i < sigs.length; ++i)
        {
            assertNotNull(
                "Returned null signature at index "+i+".",
                sigs[i] );
        }
    }
    
    
    public void testReadClass1() throws Exception
    {
        IClassMetaDataReader cmdr = createIClassMetaDataReader();
        cmdr.close();
        try
        {
            cmdr.readClass( "a" );
            fail( "Did not throw IOException." );
        }
        catch (IOException ioe)
        {
            assertNotNull( "Null exception message.", ioe.getMessage() );
        }
    }
    
    
    public void testReadClass2() throws Exception
    {
        IClassMetaDataReader cmdr = createIClassMetaDataReader();
        cmdr.close();
        try
        {
            cmdr.readClass( null );
            fail( "Did not throw IllegalArgumentException." );
        }
        catch (IllegalArgumentException ex)
        {
            assertNotNull( "Null exception message.", ex.getMessage() );
        }
    }
    
    
    public void testReadClass3() throws Exception
    {
        IClassMetaDataReader cmdr = createIClassMetaDataReader();
        String nonExistClassName = "a";
        String sigs[] = cmdr.getClassSignatures();
        boolean inSigs = true;
        while (inSigs)
        {
            nonExistClassName += "1";
            inSigs = false;
            for (int i = 0; i < sigs.length; ++i)
            {
                if (sigs[i].equals( nonExistClassName ))
                {
                    inSigs = true;
                    break;
                }
            }
        }
        
        ClassRecord cr = cmdr.readClass( nonExistClassName );
        assertNull(
            "Incorrectly returned a class for a non-existent class "+
                "signature '"+nonExistClassName+"'.",
            cr );
    }
    
    
    public void testReadAllClasses1() throws Exception
    {
        IClassMetaDataReader cmdr = createIClassMetaDataReader();
        String sigs[] = cmdr.getClassSignatures();
        assertNotNull(
            "Returned null sigs.",
            sigs );
        for (int i = 0; i < sigs.length; ++i)
        {
            ClassRecord cr = cmdr.readClass( sigs[i] );
            assertNotNull(
                "Read null class from returned class signature.",
                cr );
        }
    }
    
    
    public void testClose1() throws Exception
    {
        IClassMetaDataReader cmdr = createIClassMetaDataReader();
        cmdr.close();
    }
    
    
    public void testClose2() throws Exception
    {
        IClassMetaDataReader cmdr = createIClassMetaDataReader();
        cmdr.close();
        try
        {
            cmdr.close();
            fail( "Did not throw IOException." );
        }
        catch (IOException ex)
        {
            assertNotNull( "Null exception message.", ex.getMessage() );
        }
    }
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

