/*
 * @(#)XmlReportStyle.java
 *
 * Copyright (C) 2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

import net.sourceforge.groboutils.codecoverage.v2.report.OutputXml;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.w3c.dom.Document;



/**
 * Generates the XML file for the report.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:25 $
 * @since     March 15, 2003
 */
public class XmlReportStyle implements IReportStyle
{
    private File outdir;
    private String prefix = "CoverageReport-";
    private String suffix = ".xml";
    
    
    public void setPrefix( String p )
    {
        if (p == null)
        {
            p = "";
        }
        this.prefix = p;
    }
    
    
    public void setSuffix( String s )
    {
        if (s == null)
        {
            s = "";
        }
        this.suffix = s;
    }
    
    
    public void setDestDir( File dir )
    {
        this.outdir = dir;
    }
    
    
    /**
     * Called when the task is finished generating all the reports.  This
     * may be useful for styles that join all the reports together.
     */
    public void reportComplete( Project project, java.util.Vector errorList )
            throws BuildException, IOException
    {
        // do nothing
    }
    
    
    public void generateReport( Project project, Document doc,
            String moduleName )
            throws BuildException, IOException
    {
        if (this.outdir == null)
        {
            throw new BuildException( "Must set the 'destdir' attribute." );
        }
        project.log( "Generating XML report for module "+moduleName,
            Project.MSG_VERBOSE );
        File outFile = new File( this.outdir,
            this.prefix + moduleName + this.suffix );
        File parent = outFile.getParentFile();
        if (!parent.exists())
        {
            parent.mkdirs();
        }
        OutputStreamWriter osw = null;
        try
        {
            osw = new OutputStreamWriter( new FileOutputStream( outFile ),
                "UTF8" );
            (new OutputXml()).write( doc.getDocumentElement(), osw, null );
        }
        finally
        {
            if (osw != null)
            {
                osw.close();
            }
        }
    }
}

