# Copyright (C) 2005 JanRain, Inc.
# Copyright (C) 2009, 2010 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from apache_openid.template import Template

class Action(object):
    @property
    def template(self):
        try:
            return self._template
        except AttributeError:
            self._template = Template(self.request, self.response, self.session,
                self.options.get('template-path'))
            return self._template

    def __init__(self, request, response, session, consumer, options):
        self.request = request
        self.response = response
        self.session = session
        self.consumer = consumer
        self.options = options
