package org.jibx.schema.elements;

import java.util.ArrayList;

import org.w3c.dom.Node;

/**
 * <b>documentation</b> annotation item element.
 */
public class DocumentationElement extends AnnotationItem
{
    /** xml:lang attribute value. */
    private String m_xmlLang;
    
    /** Content of annotation item. */
    private ArrayList m_contentList;
    
    /**
     * Constructor.
     */
    public DocumentationElement() {
    	super(DOCUMENTATION_TYPE);
        m_contentList = new ArrayList();
    }

    /**
     * Get language code.
     * 
     * @return language code
     */
    public String getXmlLang() {
        return m_xmlLang;
    }

    /**
     * Set language code.
     * 
     * @param xmlLang xmlLang
     */
    public void setXmlLang(String xmlLang) {
        m_xmlLang = xmlLang;
    }

    /**
     * Get annotation item content list. This is a list consisting of DOM
     * nodes.
     * 
     * @return annotation content list
     */
    public final ArrayList getContents() {
        return m_contentList;
    }
    
    /**
     * Clear annotation item content.
     */
    public final void clearContents() {
        m_contentList.clear();
    }
    
    /**
     * Add annotation item content node.
     * 
     * @param node annotation item content node
     */
    public final void addContent(Node node) {
        m_contentList.add(node);
    }
}