#############################################################
#
# netkitrwho
#
#############################################################
ifneq ($(USE_CVS),true)
NETKITRWHO_SOURCE:=netkit-rwho.tar.gz
NETKITRWHO_SITE:=rwho://rwho.uk.linux.org/pub/linux/Networking/netkit/
NETKITRWHO_DIR:=$(BUILD_DIR)/${shell basename $(NETKITRWHO_SOURCE) .tar.gz}

NETKITRWHO_CAT:=zcat
else
# using CVS
NETKITRWHO_DIR:=$(BUILD_DIR)/netkit-rwho
endif

NETKITRWHO_BINARY:=rwho/rwho
NETKITRWHO_TARGET_BINARY:=usr/bin/rwho
NETKITRWHO_PATCH:=$(SOURCE_DIR)/netkitrwho.patch

ifneq ($(USE_CVS),true)
netkitrwho-fetch:
	 $(WGET) -P $(DL_DIR) $(NETKITRWHO_SITE)/$(NETKITRWHO_SOURCE)

netkitrwho-source: $(DL_DIR)/$(NETKITRWHO_SOURCE)
else
netkitrwho-source:
endif

NETKITRWHO_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d netkit-rwho $(CVS_TAG) $(CVS_PREFIX)netkit-rwho

netkitrwho-checkout:
	@$(NETKITRWHO_CVSCO)

$(NETKITRWHO_DIR)/.unpacked: $(DL_DIR)/$(NETKITRWHO_SOURCE)
ifneq ($(USE_CVS),true)
	$(NETKITRWHO_CAT) $(DL_DIR)/$(NETKITRWHO_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(NETKITRWHO_CVSCO)
endif
	touch $(NETKITRWHO_DIR)/.unpacked

$(NETKITRWHO_DIR)/.configured: $(NETKITRWHO_DIR)/.unpacked
	(cd $(NETKITRWHO_DIR); PATH=$(TARGET_PATH) CC=$(TARGET_CC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure --installroot=$(TARGET_DIR) --with-c-compiler=$(TARGET_CC) \
	)
	touch  $(NETKITRWHO_DIR)/.configured

$(NETKITRWHO_DIR)/$(NETKITRWHO_BINARY): $(NETKITRWHO_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(NETKITRWHO_DIR)

$(TARGET_DIR)/$(NETKITRWHO_TARGET_BINARY): $(NETKITRWHO_DIR)/$(NETKITRWHO_BINARY)
	$(MAKE) INSTALLROOT=$(TARGET_DIR) -C $(NETKITRWHO_DIR) install
	$(STRIP) $(TARGET_DIR)/$(NETKITRWHO_TARGET_BINARY) \
		$(TARGET_DIR)/usr/sbin/rwhod
	#sed -i -e "s~^#telnet.*~telnet\tstream\ttcp\tnowait\troot\t/usr/sbin/in.telnetd\t/usr/sbin/in.telnetd~;" $(TARGET_DIR)/etc/inetd.conf
	mkdir -p $(DOC_DIR)/doc/netkit-rwho
	for f in README ; do \
	    install -m0644 $(NETKITRWHO_DIR)/$$f $(DOC_DIR)/doc/netkit-rwho/$$f ; \
	done

netkitrwho: uclibc $(TARGET_DIR)/$(NETKITRWHO_TARGET_BINARY)

netkitrwho-clean:
	-rm -f $(TARGET_DIR)/$(NETKITRWHO_TARGET_BINARY)
	-$(MAKE) -C $(NETKITRWHO_DIR) clean
	-rm -rf $(DOC_DIR)/doc/netkit-rwho

netkitrwho-dirclean:
	rm -rf $(NETKITRWHO_DIR)

