#############################################################
#
# mgetty
#
#############################################################

ifneq ($(USE_CVS), true)
MGETTY_SOURCE:=mgetty.tar.gz
MGETTY_CAT:=zcat
endif

MGETTY_DIR:=$(BUILD_DIR)/mgetty
MGETTY_BINARY :=	mgetty
MGETTY_TARGET_BINARY := sbin/mgetty
MGETTY_DEFS :=		HOSTCC=gcc HOSTCFLAGS="-Os"
MGETTY_RUNTIME_DIRS :=	BINDIR="/bin" \
			LIBDIR="/lib" \
			SBINDIR="/sbin" \
			CONFDIR="/etc/default" \
			VARRUNDIR="/var/run" \
			FAX_SPOOL="/var/spool/fax" \
			FAX_SPOOL_IN="/var/spool/fax/incoming" \
			FAX_SPOOL_OUT="/var/spool/fax/outgoing" \
			MAN1DIR="/usr/share/man/man1" \
			MAN4DIR="/usr/share/man/man4" \
			MAN5DIR="/usr/share/man/man5" \
			MAN8DIR="/usr/share/man/man8" \
			INFODIR="/usr/info" 

MGETTY_INSTALL_DIRS :=	BINDIR="$(TARGET_DIR)/bin" \
			LIBDIR="$(TARGET_DIR)/lib" \
			SBINDIR="$(TARGET_DIR)/sbin" \
			CONFDIR="$(TARGET_DIR)/etc/default" \
			VARRUNDIR="$(TARGET_DIR)/var/run" \
			FAX_SPOOL="$(TARGET_DIR)/var/spool/fax" \
			FAX_SPOOL_IN="$(TARGET_DIR)/var/spool/fax/incoming" \
			FAX_SPOOL_OUT="$(TARGET_DIR)/var/spool/fax/outgoing" \
			MAN1DIR="$(TARGET_DIR)/usr/share/man/man1" \
			MAN4DIR="$(TARGET_DIR)/usr/share/man/man4" \
			MAN5DIR="$(TARGET_DIR)/usr/share/man/man5" \
			MAN8DIR="$(TARGET_DIR)/usr/share/man/man8" \
			INFODIR="$(TARGET_DIR)/usr/info" 

TARGET_LOGROTATE_DIR := $(TARGET_DIR)/etc/logrotate.d

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(MGETTY_SOURCE):

mgetty-source: $(DL_DIR)/$(MGETTY_SOURCE)
else
mgetty-source:
endif

MGETTY_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d mgetty $(CVS_TAG) $(CVS_PREFIX)mgetty

mgetty-checkout:
	@$(MGETTY_CVSCO)

$(MGETTY_DIR)/.unpacked: $(DL_DIR)/$(MGETTY_SOURCE)
ifneq ($(USE_CVS), true)
	$(MGETTY_CAT) $(DL_DIR)/$(MGETTY_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(MGETTY_CVSCO)
endif
	-cat $(SOURCE_DIR)/mgetty.patch | patch -p0 -d $(MGETTY_DIR)
	touch  $(MGETTY_DIR)/.unpacked

$(MGETTY_DIR)/.configured: $(MGETTY_DIR)/.unpacked
	cd $(MGETTY_DIR); cp policy.h-dist policy.h
	touch $(MGETTY_DIR)/.configured

$(MGETTY_DIR)/$(MGETTY_BINARY): $(MGETTY_DIR)/.configured
	$(MAKE) $(MGETTY_DEFS) $(MGETTY_RUNTIME_DIRS) $(TARGET_CONFIGURE_OPTS) -C $(MGETTY_DIR)

$(TARGET_DIR)/$(MGETTY_TARGET_BINARY): $(MGETTY_DIR)/$(MGETTY_BINARY)
	$(MAKE) $(MGETTY_INSTALL_DIRS) -C $(MGETTY_DIR) install
	-$(STRIP) $(TARGET_DIR)/$(MGETTY_TARGET_BINARY) \
		$(TARGET_DIR)/sbin/sendfax
	if [ ! -d $(TARGET_LOGROTATE_DIR) ]; then \
		mkdir --mode=0755 -p $(TARGET_LOGROTATE_DIR); \
	fi
	install -m0644 $(SOURCE_DIR)/logrotate.mgetty $(TARGET_LOGROTATE_DIR)/mgetty

mgetty: uclibc $(TARGET_DIR)/$(MGETTY_TARGET_BINARY)

mgetty-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(MGETTY_DIR) uninstall
	-$(MAKE) -C $(MGETTY_DIR) clean
	-rm -f $(TARGET_LOGROTATE_DIR)/mgetty

mgetty-dirclean:
	rm -rf $(MGETTY_DIR)

