#############################################################
#
# libpcap
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
LIBPCAP_SOURCE:=libpcap.tar.gz
LIBPCAP_SITE:=ftp://ftp.gnu.org/gnu/libpcap
LIBPCAP_CAT:=zcat
endif

LIBPCAP_DIR:=$(BUILD_DIR)/libpcap
LIBPCAP_BINARY:=libpcap.a
LIBPCAP_TARGET_BINARY:=usr/lib/libpcap.a

ifneq ($(USE_CVS),true)
libpcap-fetch:
	 $(WGET) -P $(DL_DIR) $(LIBPCAP_SITE)/$(LIBPCAP_SOURCE)

libpcap-source: $(DL_DIR)/$(LIBPCAP_SOURCE)
else
libpcap-source:
endif

LIBPCAP_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d libpcap $(CVS_TAG) $(CVS_PREFIX)libpcap

libpcap-checkout:
	@$(LIBPCAP_CVSCO)

$(LIBPCAP_DIR)/.unpacked: $(DL_DIR)/$(LIBPCAP_SOURCE)
ifneq ($(USE_CVS),true)
	$(LIBPCAP_CAT) $(DL_DIR)/$(LIBPCAP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(LIBPCAP_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(LIBPCAP_DIR)/
	touch $(LIBPCAP_DIR)/.unpacked

$(LIBPCAP_DIR)/.configured: $(LIBPCAP_DIR)/.unpacked
	(cd $(LIBPCAP_DIR); rm -rf config.cache; \
		ac_cv_linux_vers=2 \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--with-pcap=linux \
		--enable-ipv6 \
	);
	touch  $(LIBPCAP_DIR)/.configured

$(LIBPCAP_DIR)/$(LIBPCAP_BINARY): $(LIBPCAP_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(LIBPCAP_DIR)

$(STAGING_DIR)/$(LIBPCAP_TARGET_BINARY): $(LIBPCAP_DIR)/$(LIBPCAP_BINARY)
	$(MAKE) DESTDIR=$(STAGING_DIR) -C $(LIBPCAP_DIR) install
	install -d $(DOC_DIR)/doc/libpcap
	@for f in LICENSE README README.linux ; do \
		install -m0644 $(LIBPCAP_DIR)/$$f $(DOC_DIR)/doc/libpcap/$$f ;\
	done

libpcap: uclibc $(STAGING_DIR)/$(LIBPCAP_TARGET_BINARY)

libpcap-clean:
	-$(MAKE) DESTDIR=$(STAGING_DIR) -C $(LIBPCAP_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/libpcap
	-$(MAKE) -C $(LIBPCAP_DIR) clean

libpcap-dirclean:
	rm -rf $(LIBPCAP_DIR)
endif

