/*
 * linux/drivers/video/s1d13706fb.h
 *	-- Support for the Epson SED13706 LCD/CRT controller
 *
 * Copyright (C) 2003 Heiko Degenhardt <linux@sentec-elektronik.de>
 *                    Michael Huhn <michael.huhn@sentec-elektronik.de>
 *
 * Some ideas were "stolen" from 
 *    linux/drivers/video/epson1355fb.c
 *    that is "Copyright (C) 2000 Philipp Rumpf <prumpf@tux.org>"
 * and from s1d13xxxfb.c and a file called "s1d13706.h" that was
 *    generated by S1D13706CFG.EXE both are
 *    "Copyright(c) 2000, 2001 Epson Research and Development, Inc"
 *
 * HINT: If someone feels that we used his code but didn't give him
 * credits here, please email us! It was a quite complicated thing to
 * get all that working, so may be we just forgot someone! Thanks!
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file COPYING in the main directory of this archive
 * for more details.
 */

/*
 * CHANGES
 *
 * 20030312 
 *    Creation
 *    (mihu, hede)
 */

/*
 * 
 * ATTENTION!
 * This stuff is _really_ experimental, currently!
 * Feedback is really welcome!
 *
 */

/* Register defines. */

#define S1D13706_REVISION_CODE_REG		0x00

/* LUT */
#define S1D13706_LUT_B_WR_DATA_REG	0x08
#define S1D13706_LUT_G_WR_DATA_REG	0x09
#define S1D13706_LUT_R_WR_DATA_REG	0x0A
#define S1D13706_LUT_WR_ADDR_REG		0x0B
#define S1D13706_LUT_B_RD_DATA_REG		0x0C
#define S1D13706_LUT_G_RD_DATA_REG		0x0D
#define S1D13706_LUT_R_RD_DATA_REG		0x0E
#define S1D13706_LUT_RD_ADDR_REG		0x0F

#define S1D13706_PANEL_TYPE_REG		0x10

#define S1D13706_HOR_TOTAL_REG	0x12
#define S1D13706_HOR_DISPLAY_MODE_REG	0x14
#define S1D13706_HOR_DISP_PERIOD_START_POS_REG0	0x16
#define S1D13706_HOR_DISP_PERIOD_START_POS_REG1	0x17

#define S1D13706_VERT_TOTAL_REG0	0x18
#define S1D13706_VERT_TOTAL_REG1	0x19
#define S1D13706_VERT_DISPLAY_MODE_REG0	0x1C
#define S1D13706_VERT_DISPLAY_MODE_REG1	0x1D
#define S1D13706_VERT_DISP_PERIOD_START_POS_REG0	0x1E
#define S1D13706_VERT_DISP_PERIOD_START_POS_REG1	0x1F

#define S1D13706_DISPLAY_MODE_REG		0x70
#define S1D13706_DISPLAY_SP_EFFECTS_REG	0x71
#define S1D13706_POWER_SAVE_CONFIG_REG	0xA0
#define S1D13706_GPIO_REG	0xA8
#define S1D13706_GPIO_CTL1_REG	0xAD


/* The following defines are specific for our board layout! */

#ifdef CONFIG_COBRA5272
#define S1D13706_REG_OFFSET   0x40000000
#define S1D13706_FB_OFFSET    0x20000
#define S1D13706_SRAM_SIZE		0x14000

#define S1D13706_REG_BASE	MCF_MBAR + S1D13706_REG_OFFSET
#define S1D13706_FB_BASE	S1D13706_REG_OFFSET + S1D13706_FB_OFFSET

#define S1D_PHYSICAL_REG_ADDR       S1D13706_REG_OFFSET
#define S1D_PHYSICAL_VMEM_ADDR      S1D13706_FB_BASE
#define S1D_PHYSICAL_VMEM_SIZE      0x14000L


#else
#error unknown architecture
#endif

struct s1d13706fb_info {
   struct fb_info_gen gen;
};

struct s1d13706_par {
	u32 xres;
	u32 yres;

	int bpp;
	int mem_bpp;

	u32 panel_xres;
	u32 panel_yres;

	int panel_width;
};


/* Prototypes */
static void s1d13706_detect(void);
int s1d13706fb_init(void);
int s1d13706fb_setup(char*);
static int s1d13706_encode_fix(struct fb_fix_screeninfo *fix,
				const void *raw_par,
				struct fb_info_gen *info);
static int s1d13706_set_bpp(struct s1d13706_par *par, int bpp);
static int s1d13706_decode_var(const struct fb_var_screeninfo *var,
				void *raw_par,
				struct fb_info_gen *info);
static void dump_panel_data(void);
static int s1d13706_bpp_to_var(int bpp, struct fb_var_screeninfo *var);
static int s1d13706_encode_var(struct fb_var_screeninfo *var,
				const void *raw_par,
				struct fb_info_gen *info);
static void get_panel_data(struct s1d13706_par *par);
static void s1d13706_get_par(void *raw_par, struct fb_info_gen *info);
static void s1d13706_set_par(const void *par, struct fb_info_gen *info);
static int s1d13706_getcolreg(unsigned regno, unsigned *red, unsigned *green,
				unsigned *blue, unsigned *transp,
				struct fb_info *info);
static int s1d13706_setcolreg(unsigned regno, unsigned red, unsigned green,
				unsigned blue, unsigned transp,
				struct fb_info *info);
static int s1d13706_pan_display(const struct fb_var_screeninfo *var,
				struct fb_info_gen *info);
static int s1d13706_blank(int blank_mode, struct fb_info_gen *info);
static void s1d13706_set_disp(const void *unused, struct display *disp,
				struct fb_info_gen *info);
static struct s1d13706fb_info fb_info;
int __init s1d13706fb_setup(char *str);
int __init s1d13706fb_init(void);
void s1d13706fb_cleanup(struct fb_info *info);


static void set_color_bitfields(struct fb_var_screeninfo *var);
static int s1d13706_get_fix(struct fb_fix_screeninfo *fix, int con,
				struct fb_info *info);
static int s1d13706_get_var(struct fb_var_screeninfo *var, int con,
				struct fb_info *info);
static int s1d13706_set_var(struct fb_var_screeninfo *var, int con,
				struct fb_info *info);
static int s1d13706_get_cmap(struct fb_cmap *cmap, int kspc, int con,
				struct fb_info *info);
static int s1d13706_set_cmap(struct fb_cmap *cmap, int kspc, int con,
				struct fb_info *info);


/* ------------ Interfaces to hardware functions ------------ */

struct fbgen_hwswitch s1d13706_switch = {
	detect:		s1d13706_detect,
	encode_fix:	s1d13706_encode_fix,
	decode_var:	s1d13706_decode_var,
	encode_var:	s1d13706_encode_var,
	get_par:	s1d13706_get_par,
	set_par:	s1d13706_set_par,
	getcolreg:	s1d13706_getcolreg,
	setcolreg:	s1d13706_setcolreg,
	pan_display:	s1d13706_pan_display,
	blank:		s1d13706_blank,
	set_disp:	s1d13706_set_disp,
};


/* ------------ Hardware Independent Functions ------------ */

static struct fb_ops s1d13706fb_ops = {
	owner:		THIS_MODULE,
	fb_get_fix:	s1d13706_get_fix,
	fb_get_var:	s1d13706_get_var,
	fb_set_var:	s1d13706_set_var,
	fb_get_cmap:	s1d13706_get_cmap,
	fb_set_cmap:	s1d13706_set_cmap,
	fb_pan_display:	fbgen_pan_display,
};


/* The following lines are for the initialization of the controller */

typedef unsigned short S1D_INDEX;
typedef unsigned short S1D_VALUE;

typedef struct
{
    S1D_INDEX Index;
    S1D_VALUE Value;
} S1D_REGS;

static S1D_REGS aS1DRegs[] =
{
    {0x04,0x30},   // BUSCLK MEMCLK Config Register
    {0x05,0x31},   // PCLK Config  Register
    {0x10,0xD0},   // PANEL Type Register
    {0x11,0x00},   // MOD Rate Register
    {0x12,0x34},   // Horizontal Total Register
    {0x14,0x27},   // Horizontal Display Period Register
    {0x16,0x00},   // Horizontal Display Period Start Pos Register 0
    {0x17,0x00},   // Horizontal Display Period Start Pos Register 1
    {0x18,0xFF},   // Vertical Total Register 0
    {0x19,0x00},   // Vertical Total Register 1
    {0x1C,0xEF},   // Vertical Display Period Register 0
    {0x1D,0x00},   // Vertical Display Period Register 1
    {0x1E,0x00},   // Vertical Display Period Start Pos Register 0
    {0x1F,0x00},   // Vertical Display Period Start Pos Register 1
    {0x20,0x87},   // Horizontal Sync Pulse Width Register
    {0x22,0x00},   // Horizontal Sync Pulse Start Pos Register 0
    {0x23,0x00},   // Horizontal Sync Pulse Start Pos Register 1
    {0x24,0x80},   // Vertical Sync Pulse Width Register
    {0x26,0x01},   // Vertical Sync Pulse Start Pos Register 0
    {0x27,0x00},   // Vertical Sync Pulse Start Pos Register 1
    {0x70,0x03},   // Display Mode Register
    {0x71,0x00},   // Special Effects Register
    {0x74,0x00},   // Main Window Display Start Address Register 0
    {0x75,0x00},   // Main Window Display Start Address Register 1
    {0x76,0x00},   // Main Window Display Start Address Register 2
    {0x78,0x50},   // Main Window Address Offset Register 0
    {0x79,0x00},   // Main Window Address Offset Register 1
    {0x7C,0x00},   // Sub Window Display Start Address Register 0
    {0x7D,0x00},   // Sub Window Display Start Address Register 1
    {0x7E,0x00},   // Sub Window Display Start Address Register 2
    {0x80,0x50},   // Sub Window Address Offset Register 0
    {0x81,0x00},   // Sub Window Address Offset Register 1
    {0x84,0x00},   // Sub Window X Start Pos Register 0
    {0x85,0x00},   // Sub Window X Start Pos Register 1
    {0x88,0x00},   // Sub Window Y Start Pos Register 0
    {0x89,0x00},   // Sub Window Y Start Pos Register 1
    {0x8C,0x4F},   // Sub Window X End Pos Register 0
    {0x8D,0x00},   // Sub Window X End Pos Register 1
    {0x90,0xEF},   // Sub Window Y End Pos Register 0
    {0x91,0x00},   // Sub Window Y End Pos Register 1
    {0xA0,0x00},   // Power Save Config Register
    {0xA1,0x00},   // CPU Access Control Register
    {0xA2,0x00},   // Software Reset Register
    {0xA3,0x00},   // BIG Endian Support Register
    {0xA4,0x00},   // Scratch Pad Register 0
    {0xA5,0x00},   // Scratch Pad Register 1
    {0xA8,0x00},   // GPIO Config Register 0
    {0xA9,0x80},   // GPIO Config Register 1
    {0xAC,0x00},   // GPIO Status Control Register 0
    {0xAD,0x00},   // GPIO Status Control Register 1
    {0xB0,0x00},   // PWM CV Clock Control Register
    {0xB1,0x00},   // PWM CV Clock Config Register
    {0xB2,0x00},   // CV Clock Burst Length Register
    {0xB3,0x00},   // PWM Clock Duty Cycle Register
    {0xFF,0xFF},   // END
};


u8 LUT8_Color[256*3] =
{
/* Primary and secondary colors */
0x00, 0x00, 0x00,  0x00, 0x00, 0xAA,  0x00, 0xAA, 0x00,  0x00, 0xAA, 0xAA,
0xAA, 0x00, 0x00,  0xAA, 0x00, 0xAA,  0xAA, 0xAA, 0x00,  0xAA, 0xAA, 0xAA,
0x55, 0x55, 0x55,  0x00, 0x00, 0xFF,  0x00, 0xFF, 0x00,  0x00, 0xFF, 0xFF,
0xFF, 0x00, 0x00,  0xFF, 0x00, 0xFF,  0xFF, 0xFF, 0x00,  0xFF, 0xFF, 0xFF,

/* Gray shades */
0x00, 0x00, 0x00,  0x10, 0x10, 0x10,  0x20, 0x20, 0x20,  0x30, 0x30, 0x30,
0x40, 0x40, 0x40,  0x50, 0x50, 0x50,  0x60, 0x60, 0x60,  0x70, 0x70, 0x70,
0x80, 0x80, 0x80,  0x90, 0x90, 0x90,  0xA0, 0xA0, 0xA0,  0xB0, 0xB0, 0xB0,
0xC0, 0xC0, 0xC0,  0xD0, 0xD0, 0xD0,  0xE0, 0xE0, 0xE0,  0xFF, 0xFF, 0xFF,

/* Black to red */
0x00, 0x00, 0x00,  0x10, 0x00, 0x00,  0x20, 0x00, 0x00,  0x30, 0x00, 0x00,
0x40, 0x00, 0x00,  0x50, 0x00, 0x00,  0x60, 0x00, 0x00,  0x70, 0x00, 0x00,
0x80, 0x00, 0x00,  0x90, 0x00, 0x00,  0xA0, 0x00, 0x00,  0xB0, 0x00, 0x00,
0xC0, 0x00, 0x00,  0xD0, 0x00, 0x00,  0xE0, 0x00, 0x00,  0xFF, 0x00, 0x00,

/* Black to green */
0x00, 0x00, 0x00,  0x00, 0x10, 0x00,  0x00, 0x20, 0x00,  0x00, 0x30, 0x00,
0x00, 0x40, 0x00,  0x00, 0x50, 0x00,  0x00, 0x60, 0x00,  0x00, 0x70, 0x00,
0x00, 0x80, 0x00,  0x00, 0x90, 0x00,  0x00, 0xA0, 0x00,  0x00, 0xB0, 0x00,
0x00, 0xC0, 0x00,  0x00, 0xD0, 0x00,  0x00, 0xE0, 0x00,  0x00, 0xFF, 0x00,

/* Black to blue */
0x00, 0x00, 0x00,  0x00, 0x00, 0x10,  0x00, 0x00, 0x20,  0x00, 0x00, 0x30,
0x00, 0x00, 0x40,  0x00, 0x00, 0x50,  0x00, 0x00, 0x60,  0x00, 0x00, 0x70,
0x00, 0x00, 0x80,  0x00, 0x00, 0x90,  0x00, 0x00, 0xA0,  0x00, 0x00, 0xB0,
0x00, 0x00, 0xC0,  0x00, 0x00, 0xD0,  0x00, 0x00, 0xE0,  0x00, 0x00, 0xFF,

/* Blue to cyan (blue and green) */
0x00, 0x00, 0xFF,  0x00, 0x10, 0xFF,  0x00, 0x20, 0xFF,  0x00, 0x30, 0xFF,
0x00, 0x40, 0xFF,  0x00, 0x50, 0xFF,  0x00, 0x60, 0xFF,  0x00, 0x70, 0xFF,
0x00, 0x80, 0xFF,  0x00, 0x90, 0xFF,  0x00, 0xA0, 0xFF,  0x00, 0xB0, 0xFF,
0x00, 0xC0, 0xFF,  0x00, 0xD0, 0xFF,  0x00, 0xE0, 0xFF,  0x00, 0xFF, 0xFF,

/* Cyan (blue and green) to green */
0x00, 0xFF, 0xFF,  0x00, 0xFF, 0xE0,  0x00, 0xFF, 0xD0,  0x00, 0xFF, 0xC0,
0x00, 0xFF, 0xB0,  0x00, 0xFF, 0xA0,  0x00, 0xFF, 0x90,  0x00, 0xFF, 0x80,
0x00, 0xFF, 0x70,  0x00, 0xFF, 0x60,  0x00, 0xFF, 0x50,  0x00, 0xFF, 0x40,
0x00, 0xFF, 0x30,  0x00, 0xFF, 0x20,  0x00, 0xFF, 0x10,  0x00, 0xFF, 0x00,

/* Green to yellow (red and green) */
0x00, 0xFF, 0x00,  0x10, 0xFF, 0x00,  0x20, 0xFF, 0x00,  0x30, 0xFF, 0x00,
0x40, 0xFF, 0x00,  0x50, 0xFF, 0x00,  0x60, 0xFF, 0x00,  0x70, 0xFF, 0x00,
0x80, 0xFF, 0x00,  0x90, 0xFF, 0x00,  0xA0, 0xFF, 0x00,  0xB0, 0xFF, 0x00,
0xC0, 0xFF, 0x00,  0xD0, 0xFF, 0x00,  0xE0, 0xFF, 0x00,  0xFF, 0xFF, 0x00,

/* Yellow (red and green) to red */
0xFF, 0xFF, 0x00,  0xFF, 0xE0, 0x00,  0xFF, 0xD0, 0x00,  0xFF, 0xC0, 0x00,
0xFF, 0xB0, 0x00,  0xFF, 0xA0, 0x00,  0xFF, 0x90, 0x00,  0xFF, 0x80, 0x00,
0xFF, 0x70, 0x00,  0xFF, 0x60, 0x00,  0xFF, 0x50, 0x00,  0xFF, 0x40, 0x00,
0xFF, 0x30, 0x00,  0xFF, 0x20, 0x00,  0xFF, 0x10, 0x00,  0xFF, 0x00, 0x00,

/* Red to magenta (blue and red) */
0xFF, 0x00, 0x00,  0xFF, 0x00, 0x10,  0xFF, 0x00, 0x20,  0xFF, 0x00, 0x30,
0xFF, 0x00, 0x40,  0xFF, 0x00, 0x50,  0xFF, 0x00, 0x60,  0xFF, 0x00, 0x70,
0xFF, 0x00, 0x80,  0xFF, 0x00, 0x90,  0xFF, 0x00, 0xA0,  0xFF, 0x00, 0xB0,
0xFF, 0x00, 0xC0,  0xFF, 0x00, 0xD0,  0xFF, 0x00, 0xE0,  0xFF, 0x00, 0xFF,

/* Magenta (blue and red) to blue */
0xFF, 0x00, 0xFF,  0xE0, 0x00, 0xFF,  0xD0, 0x00, 0xFF,  0xC0, 0x00, 0xFF,
0xB0, 0x00, 0xFF,  0xA0, 0x00, 0xFF,  0x90, 0x00, 0xFF,  0x80, 0x00, 0xFF,
0x70, 0x00, 0xFF,  0x60, 0x00, 0xFF,  0x50, 0x00, 0xFF,  0x40, 0x00, 0xFF,
0x30, 0x00, 0xFF,  0x20, 0x00, 0xFF,  0x10, 0x00, 0xFF,  0x00, 0x00, 0xFF,

/* Black to magenta (blue and red) */
0x00, 0x00, 0x00,  0x10, 0x00, 0x10,  0x20, 0x00, 0x20,  0x30, 0x00, 0x30,
0x40, 0x00, 0x40,  0x50, 0x00, 0x50,  0x60, 0x00, 0x60,  0x70, 0x00, 0x70,
0x80, 0x00, 0x80,  0x90, 0x00, 0x90,  0xA0, 0x00, 0xA0,  0xB0, 0x00, 0xB0,
0xC0, 0x00, 0xC0,  0xD0, 0x00, 0xD0,  0xE0, 0x00, 0xE0,  0xFF, 0x00, 0xFF,

/* Black to cyan (blue and green) */
0x00, 0x00, 0x00,  0x00, 0x10, 0x10,  0x00, 0x20, 0x20,  0x00, 0x30, 0x30,
0x00, 0x40, 0x40,  0x00, 0x50, 0x50,  0x00, 0x60, 0x60,  0x00, 0x70, 0x70,
0x00, 0x80, 0x80,  0x00, 0x90, 0x90,  0x00, 0xA0, 0xA0,  0x00, 0xB0, 0xB0,
0x00, 0xC0, 0xC0,  0x00, 0xD0, 0xD0,  0x00, 0xE0, 0xE0,  0x00, 0xFF, 0xFF,

/* Red to white */
0xFF, 0x00, 0x00,  0xFF, 0x10, 0x10,  0xFF, 0x20, 0x20,  0xFF, 0x30, 0x30,
0xFF, 0x40, 0x40,  0xFF, 0x50, 0x50,  0xFF, 0x60, 0x60,  0xFF, 0x70, 0x70,
0xFF, 0x80, 0x80,  0xFF, 0x90, 0x90,  0xFF, 0xA0, 0xA0,  0xFF, 0xB0, 0xB0,
0xFF, 0xC0, 0xC0,  0xFF, 0xD0, 0xD0,  0xFF, 0xE0, 0xE0,  0xFF, 0xFF, 0xFF,

/* Green to white */
0x00, 0xFF, 0x00,  0x10, 0xFF, 0x10,  0x20, 0xFF, 0x20,  0x30, 0xFF, 0x30,
0x40, 0xFF, 0x40,  0x50, 0xFF, 0x50,  0x60, 0xFF, 0x60,  0x70, 0xFF, 0x70,
0x80, 0xFF, 0x80,  0x90, 0xFF, 0x90,  0xA0, 0xFF, 0xA0,  0xB0, 0xFF, 0xB0,
0xC0, 0xFF, 0xC0,  0xD0, 0xFF, 0xD0,  0xE0, 0xFF, 0xE0,  0xFF, 0xFF, 0xFF,

/* Blue to white */
0x00, 0x00, 0xFF,  0x10, 0x10, 0xFF,  0x20, 0x20, 0xFF,  0x30, 0x30, 0xFF,
0x40, 0x40, 0xFF,  0x50, 0x50, 0xFF,  0x60, 0x60, 0xFF,  0x70, 0x70, 0xFF,
0x80, 0x80, 0xFF,  0x90, 0x90, 0xFF,  0xA0, 0xA0, 0xFF,  0xB0, 0xB0, 0xFF,
0xC0, 0xC0, 0xFF,  0xD0, 0xD0, 0xFF,  0xE0, 0xE0, 0xFF,  0xFF, 0xFF, 0xFF
};

/*==========================================================================*/

