/* BSD `_setjmp' entry point to `sigsetjmp (..., 0)'.  FR-V version.
   Copyright (C) 1999, 2000, 2002, 2004 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

/* This just does a tail-call to `__sigsetjmp (ARG, 0)'.
   We cannot do it in C because it must be a tail-call, so frame-unwinding
   in setjmp doesn't clobber the state restored by longjmp.  */

#include <sysdep.h>

ENTRY (_setjmp)
	sethi.p	#gotofffuncdeschi(C_SYMBOL_NAME(__sigsetjmp)), gr14
	setlo	#gotofffuncdesclo(C_SYMBOL_NAME(__sigsetjmp)), gr14
	ldd.p	@(gr14, gr15), gr14
	setlos	#0, gr9
	jmpl	@(gr14, gr0)
END (_setjmp)
libc_hidden_def (_setjmp)
