% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spacer.R
\name{plot_spacer}
\alias{plot_spacer}
\title{Add a completely blank area}
\usage{
plot_spacer()
}
\value{
A \code{ggplot} object containing an empty plot
}
\description{
This simple wrapper creates an empty transparent patch that can be added to
push your other plots apart. The patch responds to adding
\link[ggplot2:theme]{theme()} specifications, but only \code{plot.background} will
have an effect.
}
\examples{
library(ggplot2)

p1 <- ggplot(mtcars) + geom_point(aes(mpg, disp))
p2 <- ggplot(mtcars) + geom_boxplot(aes(gear, disp, group = gear))

p1 + plot_spacer() + p2


# To have more control over spacing, you can use the `plot.margin`
# parameter for `theme()` on each individual plot.

(p1 + theme(plot.margin = unit(c(0,30,0,0), "pt"))) +
(p2 + theme(plot.margin = unit(c(0,0,0,30), "pt")))

}
