# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.domain import Domain
from twilio.rest.frontline_api.v1 import V1


class FrontlineApi(Domain):

    def __init__(self, twilio):
        """
        Initialize the FrontlineApi Domain

        :returns: Domain for FrontlineApi
        :rtype: twilio.rest.frontline_api.FrontlineApi
        """
        super(FrontlineApi, self).__init__(twilio)

        self.base_url = 'https://frontline-api.twilio.com'

        # Versions
        self._v1 = None

    @property
    def v1(self):
        """
        :returns: Version v1 of frontline_api
        :rtype: twilio.rest.frontline_api.v1.V1
        """
        if self._v1 is None:
            self._v1 = V1(self)
        return self._v1

    @property
    def users(self):
        """
        :rtype: twilio.rest.frontline_api.v1.user.UserList
        """
        return self.v1.users

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FrontlineApi>'
