# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class ExtendedLocationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The supported ExtendedLocation types."""

    EDGE_ZONE = "EdgeZone"
    """Azure Edge Zones location type"""
    CUSTOM_LOCATION = "CustomLocation"
    """Azure Custom Locations type"""


class KubernetesSecretType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Supported Kubernetes secret types."""

    OPAQUE = "Opaque"
    """Opaque is the default secret type."""
    TLS = "kubernetes.io/tls"
    """The kubernetes.io/tls secret type is for storing a certificate and its associated key that are
    typically used for TLS."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class StatusConditionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status conditions types."""

    TRUE = "True"
    """The status is true"""
    FALSE = "False"
    """The status is false"""
    UNKNOWN = "Unknown"
    """The status is unknown"""
