# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.authorization import AuthorizationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAuthorizationManagementRoleManagementPolicyAssignmentsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AuthorizationManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_role_management_policy_assignments_get(self, resource_group):
        response = self.client.role_management_policy_assignments.get(
            scope="str",
            role_management_policy_assignment_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_role_management_policy_assignments_create(self, resource_group):
        response = self.client.role_management_policy_assignments.create(
            scope="str",
            role_management_policy_assignment_name="str",
            parameters={
                "effectiveRules": ["role_management_policy_rule"],
                "id": "str",
                "name": "str",
                "policyAssignmentProperties": {
                    "policy": {
                        "id": "str",
                        "lastModifiedBy": {"displayName": "str", "email": "str", "id": "str", "type": "str"},
                        "lastModifiedDateTime": "2020-02-20 00:00:00",
                    },
                    "roleDefinition": {"displayName": "str", "id": "str", "type": "str"},
                    "scope": {"displayName": "str", "id": "str", "type": "str"},
                },
                "policyId": "str",
                "roleDefinitionId": "str",
                "scope": "str",
                "type": "str",
            },
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_role_management_policy_assignments_delete(self, resource_group):
        response = self.client.role_management_policy_assignments.delete(
            scope="str",
            role_management_policy_assignment_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_role_management_policy_assignments_list_for_scope(self, resource_group):
        response = self.client.role_management_policy_assignments.list_for_scope(
            scope="str",
            api_version="2024-09-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
