# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerregistry.v2025_04_01.aio import ContainerRegistryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerRegistryManagementRegistriesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerRegistryManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_registries_begin_import_image(self, resource_group):
        response = await (
            await self.client.registries.begin_import_image(
                resource_group_name=resource_group.name,
                registry_name="str",
                parameters={
                    "source": {
                        "sourceImage": "str",
                        "credentials": {"password": "str", "username": "str"},
                        "registryUri": "str",
                        "resourceId": "str",
                    },
                    "mode": "NoForce",
                    "targetTags": ["str"],
                    "untaggedTargetRepositories": ["str"],
                },
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_registries_check_name_availability(self, resource_group):
        response = await self.client.registries.check_name_availability(
            registry_name_check_request={"name": "str", "type": "Microsoft.ContainerRegistry/registries"},
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_registries_list(self, resource_group):
        response = self.client.registries.list(
            api_version="2025-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_registries_list_by_resource_group(self, resource_group):
        response = self.client.registries.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_registries_get(self, resource_group):
        response = await self.client.registries.get(
            resource_group_name=resource_group.name,
            registry_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_registries_begin_create(self, resource_group):
        response = await (
            await self.client.registries.begin_create(
                resource_group_name=resource_group.name,
                registry_name="str",
                registry={
                    "location": "str",
                    "sku": {"name": "str", "tier": "str"},
                    "adminUserEnabled": False,
                    "anonymousPullEnabled": False,
                    "creationDate": "2020-02-20 00:00:00",
                    "dataEndpointEnabled": bool,
                    "dataEndpointHostNames": ["str"],
                    "encryption": {
                        "keyVaultProperties": {
                            "identity": "str",
                            "keyIdentifier": "str",
                            "keyRotationEnabled": bool,
                            "lastKeyRotationTimestamp": "2020-02-20 00:00:00",
                            "versionedKeyIdentifier": "str",
                        },
                        "status": "str",
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "loginServer": "str",
                    "name": "str",
                    "networkRuleBypassOptions": "str",
                    "networkRuleSet": {"defaultAction": "Allow", "ipRules": [{"value": "str", "action": "Allow"}]},
                    "policies": {
                        "azureADAuthenticationAsArmPolicy": {"status": "enabled"},
                        "exportPolicy": {"status": "enabled"},
                        "quarantinePolicy": {"status": "str"},
                        "retentionPolicy": {"days": 7, "lastUpdatedTime": "2020-02-20 00:00:00", "status": "str"},
                        "trustPolicy": {"status": "str", "type": "Notary"},
                    },
                    "privateEndpointConnections": [
                        {
                            "id": "str",
                            "name": "str",
                            "privateEndpoint": {"id": "str"},
                            "privateLinkServiceConnectionState": {
                                "actionsRequired": "str",
                                "description": "str",
                                "status": "str",
                            },
                            "provisioningState": "str",
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "publicNetworkAccess": "str",
                    "status": {"displayStatus": "str", "message": "str", "timestamp": "2020-02-20 00:00:00"},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                    "zoneRedundancy": "str",
                },
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_registries_begin_delete(self, resource_group):
        response = await (
            await self.client.registries.begin_delete(
                resource_group_name=resource_group.name,
                registry_name="str",
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_registries_begin_update(self, resource_group):
        response = await (
            await self.client.registries.begin_update(
                resource_group_name=resource_group.name,
                registry_name="str",
                registry_update_parameters={
                    "adminUserEnabled": bool,
                    "anonymousPullEnabled": bool,
                    "dataEndpointEnabled": bool,
                    "encryption": {
                        "keyVaultProperties": {
                            "identity": "str",
                            "keyIdentifier": "str",
                            "keyRotationEnabled": bool,
                            "lastKeyRotationTimestamp": "2020-02-20 00:00:00",
                            "versionedKeyIdentifier": "str",
                        },
                        "status": "str",
                    },
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "networkRuleBypassOptions": "str",
                    "networkRuleSet": {"defaultAction": "Allow", "ipRules": [{"value": "str", "action": "Allow"}]},
                    "policies": {
                        "azureADAuthenticationAsArmPolicy": {"status": "enabled"},
                        "exportPolicy": {"status": "enabled"},
                        "quarantinePolicy": {"status": "str"},
                        "retentionPolicy": {"days": 7, "lastUpdatedTime": "2020-02-20 00:00:00", "status": "str"},
                        "trustPolicy": {"status": "str", "type": "Notary"},
                    },
                    "publicNetworkAccess": "str",
                    "sku": {"name": "str", "tier": "str"},
                    "tags": {"str": "str"},
                },
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_registries_list_usages(self, resource_group):
        response = await self.client.registries.list_usages(
            resource_group_name=resource_group.name,
            registry_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_registries_list_private_link_resources(self, resource_group):
        response = self.client.registries.list_private_link_resources(
            resource_group_name=resource_group.name,
            registry_name="str",
            api_version="2025-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_registries_get_private_link_resource(self, resource_group):
        response = await self.client.registries.get_private_link_resource(
            resource_group_name=resource_group.name,
            registry_name="str",
            group_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_registries_list_credentials(self, resource_group):
        response = await self.client.registries.list_credentials(
            resource_group_name=resource_group.name,
            registry_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_registries_regenerate_credential(self, resource_group):
        response = await self.client.registries.regenerate_credential(
            resource_group_name=resource_group.name,
            registry_name="str",
            regenerate_credential_parameters={"name": "str"},
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_registries_begin_generate_credentials(self, resource_group):
        response = await (
            await self.client.registries.begin_generate_credentials(
                resource_group_name=resource_group.name,
                registry_name="str",
                generate_credentials_parameters={"expiry": "2020-02-20 00:00:00", "name": "str", "tokenId": "str"},
                api_version="2025-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
