# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import TYPE_CHECKING

from azure.core import PipelineClient
from msrest import Deserializer, Serializer

from ._configuration import PurviewScanningClientConfiguration
from .operations import ClassificationRulesOperations, DataSourcesOperations, FiltersOperations, KeyVaultConnectionsOperations, ScanResultOperations, ScanRulesetsOperations, ScansOperations, SystemScanRulesetsOperations, TriggersOperations

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Dict, Optional

    from azure.core.credentials import TokenCredential
    from azure.core.rest import HttpRequest, HttpResponse

class PurviewScanningClient(object):
    """Creates a Microsoft.Scanning management client.

    :ivar key_vault_connections: KeyVaultConnectionsOperations operations
    :vartype key_vault_connections: azure.purview.scanning.operations.KeyVaultConnectionsOperations
    :ivar classification_rules: ClassificationRulesOperations operations
    :vartype classification_rules: azure.purview.scanning.operations.ClassificationRulesOperations
    :ivar data_sources: DataSourcesOperations operations
    :vartype data_sources: azure.purview.scanning.operations.DataSourcesOperations
    :ivar filters: FiltersOperations operations
    :vartype filters: azure.purview.scanning.operations.FiltersOperations
    :ivar scans: ScansOperations operations
    :vartype scans: azure.purview.scanning.operations.ScansOperations
    :ivar scan_result: ScanResultOperations operations
    :vartype scan_result: azure.purview.scanning.operations.ScanResultOperations
    :ivar scan_rulesets: ScanRulesetsOperations operations
    :vartype scan_rulesets: azure.purview.scanning.operations.ScanRulesetsOperations
    :ivar system_scan_rulesets: SystemScanRulesetsOperations operations
    :vartype system_scan_rulesets: azure.purview.scanning.operations.SystemScanRulesetsOperations
    :ivar triggers: TriggersOperations operations
    :vartype triggers: azure.purview.scanning.operations.TriggersOperations
    :param endpoint: The scanning endpoint of your purview account. Example:
     https://{accountName}.scan.purview.azure.com.
    :type endpoint: str
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    """

    def __init__(
        self,
        endpoint,  # type: str
        credential,  # type: "TokenCredential"
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        _endpoint = '{Endpoint}'
        self._config = PurviewScanningClientConfiguration(endpoint, credential, **kwargs)
        self._client = PipelineClient(base_url=_endpoint, config=self._config, **kwargs)

        self._serialize = Serializer()
        self._deserialize = Deserializer()
        self._serialize.client_side_validation = False
        self.key_vault_connections = KeyVaultConnectionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.classification_rules = ClassificationRulesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.data_sources = DataSourcesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.filters = FiltersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.scans = ScansOperations(self._client, self._config, self._serialize, self._deserialize)
        self.scan_result = ScanResultOperations(self._client, self._config, self._serialize, self._deserialize)
        self.scan_rulesets = ScanRulesetsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.system_scan_rulesets = SystemScanRulesetsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.triggers = TriggersOperations(self._client, self._config, self._serialize, self._deserialize)


    def send_request(
        self,
        request,  # type: HttpRequest
        **kwargs  # type: Any
    ):
        # type: (...) -> HttpResponse
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client.send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/python/protocol/quickstart

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }

        request_copy.url = self._client.format_url(request_copy.url, **path_format_arguments)
        return self._client.send_request(request_copy, **kwargs)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> PurviewScanningClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
