/*
 * Cogl
 *
 * A Low Level GPU Graphics and Utilities API
 *
 * Copyright (C) 2008 OpenedHand
 * Copyright (C) 2012 Intel Corporation.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *
 * Authors:
 *   Neil Roberts <neil@linux.intel.com>
 *   Robert Bragg <robert@linux.intel.com>
 *   Matthew Allum  <mallum@openedhand.com>
 */

#ifndef __COGL_PANGO_PRIVATE_H__
#define __COGL_PANGO_PRIVATE_H__

#include "cogl-pango.h"

G_BEGIN_DECLS

PangoRenderer *
_cogl_pango_renderer_new (CoglContext *context);

void
_cogl_pango_renderer_clear_glyph_cache  (CoglPangoRenderer *renderer);

void
_cogl_pango_renderer_set_use_mipmapping (CoglPangoRenderer *renderer,
                                         gboolean value);
gboolean
_cogl_pango_renderer_get_use_mipmapping (CoglPangoRenderer *renderer);



CoglContext *
_cogl_pango_font_map_get_cogl_context (CoglPangoFontMap *fm);

PangoRenderer *
_cogl_pango_font_map_get_renderer (CoglPangoFontMap *fm);

G_END_DECLS

#endif /* __COGL_PANGO_PRIVATE_H__ */
