/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.MeasurementSet;
import com.google.caliper.MeasurementType;
import com.google.common.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@GwtCompatible
public final class ScenarioResult
implements Serializable {
    private Map<String, MeasurementSet> measurementSetMap = new HashMap<String, MeasurementSet>();
    private Map<String, String> eventLogMap = new HashMap<String, String>();

    public ScenarioResult(MeasurementSet timeMeasurementSet, String timeEventLog, MeasurementSet instanceMeasurementSet, String instanceEventLog, MeasurementSet memoryMeasurementSet, String memoryEventLog) {
        if (timeMeasurementSet != null) {
            this.measurementSetMap.put(MeasurementType.TIME.toString(), timeMeasurementSet);
            this.eventLogMap.put(MeasurementType.TIME.toString(), timeEventLog);
        }
        if (instanceMeasurementSet != null) {
            this.measurementSetMap.put(MeasurementType.INSTANCE.toString(), instanceMeasurementSet);
            this.eventLogMap.put(MeasurementType.INSTANCE.toString(), instanceEventLog);
        }
        if (memoryMeasurementSet != null) {
            this.measurementSetMap.put(MeasurementType.MEMORY.toString(), memoryMeasurementSet);
            this.eventLogMap.put(MeasurementType.MEMORY.toString(), memoryEventLog);
        }
    }

    public MeasurementSet getMeasurementSet(MeasurementType type) {
        return this.measurementSetMap.get(type.toString());
    }

    public String getEventLog(MeasurementType type) {
        return this.eventLogMap.get(type.toString());
    }

    public boolean equals(Object o) {
        return o instanceof ScenarioResult && ((ScenarioResult)o).measurementSetMap.equals(this.measurementSetMap) && ((ScenarioResult)o).eventLogMap.equals(this.eventLogMap);
    }

    public int hashCode() {
        return this.measurementSetMap.hashCode() * 37 + this.eventLogMap.hashCode();
    }

    public String toString() {
        return "measurementSetMap: " + this.measurementSetMap + ", eventLogMap: " + this.eventLogMap;
    }

    private ScenarioResult() {
    }
}

