#include "config.h"
#ifdef ENABLE_NISEMU


#include <rpc/rpc.h>
#include "rpcsvc/nis.h"

/* Default timeout can be changed using clnt_control() */
static struct timeval TIMEOUT = { 25, 0 };

nis_result *
nis_lookup_3(argp, clnt)
	ns_request *argp;
	CLIENT *clnt;
{
	static nis_result res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_LOOKUP, xdr_ns_request, argp, xdr_nis_result, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

nis_result *
nis_add_3(argp, clnt)
	ns_request *argp;
	CLIENT *clnt;
{
	static nis_result res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_ADD, xdr_ns_request, argp, xdr_nis_result, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

nis_result *
nis_modify_3(argp, clnt)
	ns_request *argp;
	CLIENT *clnt;
{
	static nis_result res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_MODIFY, xdr_ns_request, argp, xdr_nis_result, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

nis_result *
nis_remove_3(argp, clnt)
	ns_request *argp;
	CLIENT *clnt;
{
	static nis_result res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_REMOVE, xdr_ns_request, argp, xdr_nis_result, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

nis_result *
nis_iblist_3(argp, clnt)
	ib_request *argp;
	CLIENT *clnt;
{
	static nis_result res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_IBLIST, xdr_ib_request, argp, xdr_nis_result, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

nis_result *
nis_ibadd_3(argp, clnt)
	ib_request *argp;
	CLIENT *clnt;
{
	static nis_result res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_IBADD, xdr_ib_request, argp, xdr_nis_result, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

nis_result *
nis_ibmodify_3(argp, clnt)
	ib_request *argp;
	CLIENT *clnt;
{
	static nis_result res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_IBMODIFY, xdr_ib_request, argp, xdr_nis_result, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

nis_result *
nis_ibremove_3(argp, clnt)
	ib_request *argp;
	CLIENT *clnt;
{
	static nis_result res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_IBREMOVE, xdr_ib_request, argp, xdr_nis_result, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

nis_result *
nis_ibfirst_3(argp, clnt)
	ib_request *argp;
	CLIENT *clnt;
{
	static nis_result res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_IBFIRST, xdr_ib_request, argp, xdr_nis_result, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

nis_result *
nis_ibnext_3(argp, clnt)
	ib_request *argp;
	CLIENT *clnt;
{
	static nis_result res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_IBNEXT, xdr_ib_request, argp, xdr_nis_result, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

fd_result *
nis_finddirectory_3(argp, clnt)
	fd_args *argp;
	CLIENT *clnt;
{
	static fd_result res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_FINDDIRECTORY, xdr_fd_args, argp, xdr_fd_result, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

nis_taglist *
nis_status_3(argp, clnt)
	nis_taglist *argp;
	CLIENT *clnt;
{
	static nis_taglist res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_STATUS, xdr_nis_taglist, argp, xdr_nis_taglist, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

log_result *
nis_dumplog_3(argp, clnt)
	dump_args *argp;
	CLIENT *clnt;
{
	static log_result res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_DUMPLOG, xdr_dump_args, argp, xdr_log_result, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

log_result *
nis_dump_3(argp, clnt)
	dump_args *argp;
	CLIENT *clnt;
{
	static log_result res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_DUMP, xdr_dump_args, argp, xdr_log_result, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

bool_t *
nis_callback_3(argp, clnt)
	netobj *argp;
	CLIENT *clnt;
{
	static bool_t res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_CALLBACK, xdr_netobj, argp, xdr_bool, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

u_long *
nis_cptime_3(argp, clnt)
	nis_name *argp;
	CLIENT *clnt;
{
	static u_long res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_CPTIME, xdr_nis_name, argp, xdr_u_long, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

cp_result *
nis_checkpoint_3(argp, clnt)
	nis_name *argp;
	CLIENT *clnt;
{
	static cp_result res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_CHECKPOINT, xdr_nis_name, argp, xdr_cp_result, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

void *
nis_ping_3(argp, clnt)
	ping_args *argp;
	CLIENT *clnt;
{
	static char res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_PING, xdr_ping_args, argp, xdr_void, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return ((void *)&res);
}

nis_taglist *
nis_servstate_3(argp, clnt)
	nis_taglist *argp;
	CLIENT *clnt;
{
	static nis_taglist res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_SERVSTATE, xdr_nis_taglist, argp, xdr_nis_taglist, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

nis_error *
nis_mkdir_3(argp, clnt)
	nis_name *argp;
	CLIENT *clnt;
{
	static nis_error res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_MKDIR, xdr_nis_name, argp, xdr_nis_error, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

nis_error *
nis_rmdir_3(argp, clnt)
	nis_name *argp;
	CLIENT *clnt;
{
	static nis_error res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_RMDIR, xdr_nis_name, argp, xdr_nis_error, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

nis_error *
nis_updkeys_3(argp, clnt)
	nis_name *argp;
	CLIENT *clnt;
{
	static nis_error res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, NIS_UPDKEYS, xdr_nis_name, argp, xdr_nis_error, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

#endif /* ENABLE_NISEMU */
