#include "config.h"
#ifdef ENABLE_NISEMU


#include "nis_callback.h"
#include <stdio.h>
#include <stdlib.h>/* getenv, exit */
#include <rpc/pmap_clnt.h> /* for pmap_unset */
#include <string.h> /* strcmp */ 
#include <memory.h>
#include <sys/socket.h>
#include <netinet/in.h>

#ifdef __STDC__
#define SIG_PF void(*)(int)
#endif


static void
cb_prog_1(struct svc_req *rqstp, register SVCXPRT *transp)
{
	union {
		cback_data cbproc_receive_1_arg;
		nis_error cbproc_error_1_arg;
	} argument;
	char *result;
	xdrproc_t xdr_argument, xdr_result;
	char *(*local)(char *, struct svc_req *);

	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void) svc_sendreply(transp, (xdrproc_t) xdr_void, (char *)NULL);
		return;

	case CBPROC_RECEIVE:
		xdr_argument = (xdrproc_t) xdr_cback_data;
		xdr_result = (xdrproc_t) xdr_bool;
		local = (char *(*)(char *, struct svc_req *)) cbproc_receive_1_svc;
		break;

	case CBPROC_FINISH:
		xdr_argument = (xdrproc_t) xdr_void;
		xdr_result = (xdrproc_t) xdr_void;
		local = (char *(*)(char *, struct svc_req *)) cbproc_finish_1_svc;
		break;

	case CBPROC_ERROR:
		xdr_argument = (xdrproc_t) xdr_nis_error;
		xdr_result = (xdrproc_t) xdr_void;
		local = (char *(*)(char *, struct svc_req *)) cbproc_error_1_svc;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
	(void) memset((char *)&argument, 0, sizeof (argument));
	if (!svc_getargs(transp, xdr_argument, (caddr_t) &argument)) {
		svcerr_decode(transp);
		return;
	}
	result = (*local)((char *)&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, xdr_result, result)) {
		svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, xdr_argument, (caddr_t) &argument)) {
		fprintf(stderr, "unable to free arguments");
		exit(1);
	}
	return;
}

int
_nis_cb_main(int argc, char **argv)
{
	register SVCXPRT *transp;

	(void) pmap_unset(CB_PROG, CB_VERS);

	transp = svcudp_create(RPC_ANYSOCK);
	if (transp == NULL) {
		fprintf(stderr, "cannot create udp service.");
		exit(1);
	}
	if (!svc_register(transp, CB_PROG, CB_VERS, cb_prog_1, IPPROTO_UDP)) {
		fprintf(stderr, "unable to register (CB_PROG, CB_VERS, udp).");
		exit(1);
	}

	transp = svctcp_create(RPC_ANYSOCK, 0, 0);
	if (transp == NULL) {
		fprintf(stderr, "cannot create tcp service.");
		exit(1);
	}
	if (!svc_register(transp, CB_PROG, CB_VERS, cb_prog_1, IPPROTO_TCP)) {
		fprintf(stderr, "unable to register (CB_PROG, CB_VERS, tcp).");
		exit(1);
	}

	svc_run();
	fprintf(stderr, "svc_run returned");
	exit(1);
	/* NOTREACHED */
}

#endif
