/*
** nis_passwd.c              NIS+ Passwd map access routines
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Author: Peter Eriksson <pen@signum.se>
*/

#include "config.h"

#ifdef ENABLE_NIS


#include <stdio.h>
#include <errno.h>
#include <pwd.h>
#include <rpcsvc/nis.h>
#include "xalloc.h"


static nis_result *res = NULL;
static nis_name *names = NULL;



void nis_setpwent(void)
{
    if (res)
    {
       nis_freeresult(res);
       res = NULL;
   }
}


void nis_endpwent(void)
{
    if (res)
    {
	nis_freeresult(res);
	res = NULL;
    }

    if (names)
    {
	nis_freenames(names);
	names = NULL;
    }
}

#if 0
#define NISENTRYCOL(idx,col,res) \
	xdup((res)->objects.objects_val[(idx)].zo_data.objdata_u.en_data.en_cols.en_cols_val[(col)].ec_value.ec_value_val, \
	(res)->objects.objects_val[(idx)].zo_data.objdata_u.en_data.en_cols.en_cols_val[(col)].ec_value.ec_value_len)
#else
#define NISENTRYCOL(idx,col,res) \
	((res)->objects.objects_val[(idx)].zo_data.objdata_u.en_data.en_cols.en_cols_val[(col)].ec_value.ec_value_val)
#endif


struct passwd *nis_getpwent(void)
{
    static struct passwd pwd;
    

    if (res == NULL)
    {
	if (names)
	    nis_freenames(names);

	names = nis_getnames("passwd.org_dir");
	if (names == NULL || names[0] == NULL)
	    return NULL;
	
	res = nis_first_entry(names[0]);
    }
    else
	res = nis_next_entry(names[0], &res->cookie);

    if (res == NULL)
	return NULL;

    if (res->status != 0 && res->status != 1)
    {
	/* XXX errno ? XXX */
	return NULL;
    }

/* XXX Should assert that the result returned really is valid passwd data */
    
    pwd.pw_name   = NISENTRYCOL(0, 0, res);
    pwd.pw_passwd = NISENTRYCOL(0, 1, res);
    pwd.pw_uid = atoi(NISENTRYCOL(0, 2, res));
    pwd.pw_gid = atoi(NISENTRYCOL(0, 3, res));
    pwd.pw_gecos = NISENTRYCOL(0, 4, res);
    pwd.pw_dir = NISENTRYCOL(0, 5, res);
    pwd.pw_shell = NISENTRYCOL(0, 6, res);

    return &pwd;
}


struct passwd *nis_getpwuid(int uid)
{
    errno = ECONNREFUSED;
    return NULL;
}


struct passwd *nis_getpwnam(const char *name)
{
    errno = ECONNREFUSED;
    return NULL;
}

#endif /* ENABLE_NIS */
