/*
** shadow.h           Shadow passwd "map" handling functions
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Author: Peter Eriksson <pen@signum.se>
*/

#ifndef __SHADOW_H__
#define __SHADOW_H__

#include <sys/types.h>

#define _PATH_SHADOW "/etc/shadow"


struct spwd
{
    char *sp_namp;
    char *sp_pwdp;
    long sp_lstchg;
    long sp_min;
    long sp_max;
    long sp_warn;
    long sp_inact;
    long sp_expire;
    unsigned long sp_flag;
};


extern void _setspent(void);
extern void _endspent(void);
extern struct spwd *_getspent(void);
extern struct spwd *_getspnam(const char *name);

extern struct spwd *sgetspent(char *buf);
extern struct spwd *fgetspent(FILE *fp);

extern int sputspent(struct spwd *sp, char *buf);
extern int fputspent(struct spwd *sp, FILE *fp);

extern void setspent(void);
extern void endspent(void);
extern struct spwd *getspent(void);
extern struct spwd *getspnam(const char *name);

/* John F. Haugh II shadow library compatibility function */
extern int putspent(struct spwd *sp, FILE *fp);

#endif
