/*
 *  Top - a top users display for Berkeley Unix
 *
 *  Definitions for things that might vary between installations.
 */

/*
 *  The space command forces an immediate update.  Sometimes, on loaded
 *  systems, this update will take a significant period of time (because all
 *  the output is buffered).  So, if the short-term load average is above
 *  "LoadMax", then top will put the cursor home immediately after the space
 *  is pressed before the next update is attempted.  This serves as a visual
 *  acknowledgement of the command.  On Suns, "LoadMax" will get multiplied by
 *  "FSCALE" before being compared to avenrun[0].  Therefore, "LoadMax"
 *  should always be specified as a floating point number.
 */
#ifndef LoadMax
#define LoadMax  5.0
#endif

/*
 *  "Table_size" defines the size of the hash tables used to map uid to
 *  username.  The number of users in /etc/passwd CANNOT be greater than
 *  this number.  If the error message "table overflow: too many users"
 *  is printed by top, then "Table_size" needs to be increased.  Things will
 *  work best if the number is a prime number that is about twice the number
 *  of lines in /etc/passwd.
 */
#ifndef Table_size
#define Table_size	421
#endif

/*
 *  "Nominal_TOPN" is used as the default TOPN when Default_TOPN is Infinity
 *  and the output is a dumb terminal.  If we didn't do this, then
 *  installations who use a default TOPN of Infinity will get every
 *  process in the system when running top on a dumb terminal (or redirected
 *  to a file).  Note that Nominal_TOPN is a default:  it can still be
 *  overridden on the command line, even with the value "infinity".
 */
#ifndef Nominal_TOPN
#define Nominal_TOPN	18
#endif

/*
 *  If the local system's getpwnam interface uses random access to retrieve
 *  a record (i.e.: 4.3 systems, Sun "yellow pages"), then defining
 *  PW_RANDOM will take advantage of that fact.  If PW_RANDOM is defined,
 *  then getpwnam is used and the result is cached.  If not, then getpwent
 *  is used to read and cache the password entries sequentially until the
 *  desired one is found.
 */
/* #define PW_RANDOM */

/*
 *  File name for the system image and the memory devices.
 */
#define VMUNIX	"/vmunix"
#define KMEM	"/dev/kmem"
#define MEM	"/dev/mem"

/*
 *  Warning:  size effects of a moderate kludge ahead!
 *  There are one or two points in the screen handling code where we want to
 *  know how many characters were written between two points.  The following
 *  macro returns some flavor of magic cookie that gets incremented for
 *  every character that gets written.  The best thing to use with the
 *  standard Unix FILE structure is the internal buffer pointer.  This macro
 *  is placed here in case you have a non-standard implementation of
 *  standard i/o and need to change it.
 */

#define fileptr(p)	((int)((p)->_ptr))
