/*
 *
 *
 *
 *
 */
#include <stdio.h>
#include <rpc/rpc.h>
#include "ether.h"

#define NDPROTO 0
#define ICMPPROTO 1
#define UDPPROTO 2
#define TCPPROTO 3
#define ARPPROTO 4
#define OTHERPROTO 5


static CLIENT *Client;
static etherstat PrevStatData = { { 0, 0 }, 0, 0, 0,
				  { 0, 0, 0, 0, 0, 0, 0, 0, 
				    0, 0, 0, 0, 0, 0, 0, 0 },
				  { 0, 0, 0, 0, 0, 0 } };
static etherstat *StatData = NULL;
static double TimeDelta = 1.0;

void InitRPC( host )
char *host;
{

	Client = clnt_create( host, ETHERPROG, ETHERVERS, "udp" );

	if( Client == NULL ) {
		fprintf( stderr, "xtr: Could not create connection to " );
		fprintf( stderr, "'%s'\n", host );
		exit( 1 );
	}
}

void TurnOnEther()
{
	int dummy;

	etherproc_on_1( &dummy, Client );
}

void TurnOffEther()
{
	int dummy;

	etherproc_off_1( &dummy, Client );
}
int GetStatData()
{
        int dummy;
	double start_secs, stop_secs;

        if( StatData != NULL ) {
                PrevStatData = *StatData;
        }

        if ((StatData = etherproc_getdata_1( &dummy, Client )) == 0) return ( 0 );
	gettimeofday(&StatData->e_time, (struct timezone *) 0);
	start_secs = (double)PrevStatData.e_time.tv_seconds + 
	             (double)PrevStatData.e_time.tv_useconds/1000000.0;
	stop_secs = (double)StatData->e_time.tv_seconds + 
	            (double)StatData->e_time.tv_useconds/1000000.0;
        TimeDelta = stop_secs - start_secs;

        if( TimeDelta <= 0 ) {
                TimeDelta = 1.0;
        }
	return ( 1 );
}

float GetNetLoad()
{
	long bits;
	int delta;
	float nload;
	static short firstTime=1;

	if (firstTime){
	    PrevStatData = *StatData;
	    firstTime=0;
	}
	bits = (StatData->e_bytes - PrevStatData.e_bytes) * 8;
/*	delta = (StatData->e_time.tv_seconds - PrevStatData.e_time.tv_seconds);*/
	if ( TimeDelta )
	    nload = (float)((( (double)bits / TimeDelta ) / 
			    ((double)(10 * 1024 * 1024))) * 100.0);
	else
	    nload = 0;
	nload /= 10.0;

/* occasionally a glitch comes through and we go way over 100%. the following
   limits the output to 100%. */

	if ( nload > 10.0 ) nload = 10.0;
#ifdef DEBUG
	printf ("newbytes=%d, oldbytes=%d, deltabytes=%d, deltatime=%lf, load=%f\n", 
		StatData->e_bytes,
		PrevStatData.e_bytes,
		StatData->e_bytes - PrevStatData.e_bytes,
		TimeDelta,
		nload);  
#endif
	return( nload );

}
