/*
 * java.net.DatagramSocket.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <native.h>
#include "../native/java.io/FileDescriptor.h"
#include "java.net/DatagramPacket.h"
#include "java.net/DatagramSocket.h"
#include "nets.h"

/*
 * Create a datagram socket.
 */
void
java_net_DatagramSocket_datagramSocketCreate(struct Hjava_net_DatagramSocket* this)
{
	int fd;

	fd = threadedCreateSocket(AF_INET, SOCK_DGRAM, 0);
	unhand(unhand(this)->fd)->fd = fd;
	if (fd < 0) {
		SignalError(0, "java.net.SocketException", SYS_ERROR);
	}
}

/*
 * Bind a port to the socket.
 */
long
java_net_DatagramSocket_datagramSocketBind(struct Hjava_net_DatagramSocket* this, long port)
{
	int r;
	struct sockaddr_in addr;

#if defined(BSD44)
	addr.sin_len = sizeof(addr);
#endif
	addr.sin_family = AF_INET;
	addr.sin_port = port;
	addr.sin_addr.s_addr = INADDR_ANY;

	r = bind(unhand(unhand(this)->fd)->fd, (struct sockaddr*)&addr, sizeof(addr));
	if (r < 0) {
		SignalError(0, "java.net.SocketException", SYS_ERROR);
	}

	return (addr.sin_port);
}

void
java_net_DatagramSocket_datagramSocketSend(struct Hjava_net_DatagramSocket* this, struct Hjava_net_DatagramPacket* pkt)
{
	abort();
}

long
java_net_DatagramSocket_datagramSocketPeek(struct Hjava_net_DatagramSocket* this, struct Hjava_net_InetAddress* addr)
{
	abort();
}

void
java_net_DatagramSocket_datagramSocketReceive(struct Hjava_net_DatagramSocket* this, struct Hjava_net_DatagramPacket* pkt)
{
	abort();
}

/*
 * Close the socket.
 */
void
java_net_DatagramSocket_datagramSocketClose(struct Hjava_net_DatagramSocket* this)
{
	int r;

	r = close(unhand(unhand(this)->fd)->fd);
	if (r < 0) {
		SignalError(0, "java.net.SocketException", SYS_ERROR);
	}
}
