/*
 * java.util.Date.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <time.h>
#include <native.h>
#include "config.h"
#include "java.util/Date.h"

/*
 * Convert a date to a string.
 */
struct Hjava_lang_String*
java_util_Date_toString(struct Hjava_util_Date* this)
{
	long date;
	char* str;

	if (unhand(this)->valueValid == 0) {
		java_util_Date_computeValue(this);
	}
	date = unhand(this)->value / 1000;
	str = ctime(&date);
	return(makeJavaString(str, strlen(str)));
}

/*
 * Convert a date to a string in the local timezone.
 */
struct Hjava_lang_String*
java_util_Date_toLocaleString(struct Hjava_util_Date* this)
{
	long date;
	char* str;

	if (unhand(this)->valueValid == 0) {
		java_util_Date_computeValue(this);
	}
	date = unhand(this)->value / 1000;
	str = asctime(localtime(&date));
	return(makeJavaString(str, strlen(str)));
}

/*
 * Covert a date to a string in GMT timezone.
 */
struct Hjava_lang_String*
java_util_Date_toGMTString(struct Hjava_util_Date* this)
{
	long date;
	char* str;

	if (unhand(this)->valueValid == 0) {
		java_util_Date_computeValue(this);
	}
	date = unhand(this)->value / 1000;
	str = asctime(gmtime(&date));
	return(makeJavaString(str, strlen(str)));
}

/*
 * Expand the single value into a split date.
 */
void
java_util_Date_expand(struct Hjava_util_Date* this)
{
	struct tm* time;
	long date;

	date = unhand(this)->value;
	time = localtime(&date);

	unhand(this)->tm_millis = 0;
	unhand(this)->tm_sec = time->tm_sec;
	unhand(this)->tm_min = time->tm_min;
	unhand(this)->tm_hour = time->tm_hour;
	unhand(this)->tm_mday = time->tm_mday;
	unhand(this)->tm_mon = time->tm_mon;
	unhand(this)->tm_year = time->tm_year;
	unhand(this)->tm_wday = time->tm_wday;
	unhand(this)->tm_yday = time->tm_yday;
	unhand(this)->tm_isdst = time->tm_isdst;

	unhand(this)->expanded = 1;
}

/*
 * Convert the split date into a single value.
 */
void
java_util_Date_computeValue(struct Hjava_util_Date* this)
{
	struct tm time;

	time.tm_sec = unhand(this)->tm_sec;
	time.tm_min = unhand(this)->tm_min;
	time.tm_hour = unhand(this)->tm_hour;
	time.tm_mday = unhand(this)->tm_mday;
	time.tm_mon = unhand(this)->tm_mon;
	time.tm_year = unhand(this)->tm_year;
	time.tm_wday = unhand(this)->tm_wday;
	time.tm_yday = unhand(this)->tm_yday;
	time.tm_isdst = unhand(this)->tm_isdst;
#if defined(HAVE_TM_ZONE)
	time.tm_gmtoff = 0;
	time.tm_zone = 0;
#endif

	unhand(this)->valueValid = 1;
	unhand(this)->value = 1000LL * (long long)mktime(&time);
}
