/*
 * java.lang.Runtime.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include "config.h"
#include <stdio.h>
#include <assert.h>
#include <native.h>
#include <sys/param.h>
#include "defs.h"
#include "files.h"
#include "java.lang/Runtime.h"

#define	LIBRARY_PREFIX	"/libkaffe_"

extern char* getLibraryPath();

/*
 * Initialise the linker and return the search path for shared libraries.
 */
struct Hjava_lang_String*
java_lang_Runtime_initializeLinkerInternal(struct Hjava_lang_Runtime* this)
{
	char* libraryPath;

	libraryPath = getLibraryPath();
	return (makeJavaString(libraryPath, strlen(libraryPath)));
}

/*
 * Construct a library name.
 */
struct Hjava_lang_String*
java_lang_Runtime_buildLibName(struct Hjava_lang_Runtime* this, struct Hjava_lang_String* s1, struct Hjava_lang_String* s2)
{
	char lib[MAXLIBPATH];
	char str[MAXPATHLEN];

	javaString2CString(s1, str, sizeof(str));
	strcpy(lib, str);
	strcat(lib, LIBRARY_PREFIX);
	javaString2CString(s2, str, sizeof(str));
	strcat(lib, str);
	strcat(lib, LIBRARYSUFFIX);

	return (makeJavaString(lib, strlen(lib)));
}

/*
 * Load in a library file.
 */
long /* bool */
java_lang_Runtime_loadFileInternal(struct Hjava_lang_Runtime* this, struct Hjava_lang_String* s1)
{
	char lib[MAXPATHLEN];
	int r;

	javaString2CString(s1, lib, sizeof(lib));
	r = loadNativeLibrary(lib);

	return (r == 0 ? 1 : 0);
}

/*
 * Exit - is this just a thread or the whole thing?
 */
void
java_lang_Runtime_exitInternal(struct Hjava_lang_Runtime* r, long v)
{
	exit (v);
}

/*
 * Exec another program.
 */
struct Hjava_lang_Process*
java_lang_Runtime_execInternal(struct Hjava_lang_Runtime* this, HArray* args, HArray* envs)
{
	abort();
}

/*
 * Free memory.
 */
long long java_lang_Runtime_freeMemory(struct Hjava_lang_Runtime* this)
{
	abort();
	return (0);
}

/*
 * Total memory.
 */
long long
java_lang_Runtime_totalMemory(struct Hjava_lang_Runtime* this)
{
	return (0);
}

/*
 * Run the garbage collector.
 */
void
java_lang_Runtime_gc(struct Hjava_lang_Runtime* this)
{
	invokeGarbageCollector();
}

/*
 * Run any pending finialized methods.
 *  Finalising is part of the garbage collection system - so just run that.
 */
void
java_lang_Runtime_runFinalization(struct Hjava_lang_Runtime* this)
{
	invokeGarbageCollector();
}

/*
 * Enable/disable tracing of instructions.
 */
void
java_lang_Runtime_traceInstructions(struct Hjava_lang_Runtime* this, long on)
{
	abort();
}

/*
 * Enable/disable tracing of method calls.
 */
void
java_lang_Runtime_traceMethodCalls(struct Hjava_lang_Runtime* this, long on)
{
	abort();
}
