/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.	
  
   3.26.90	Harry Morris, morris@think.com
   3.30.90  Harry Morris - Changed any->bits to any->bytes
*/

/* Copyright (c) CNIDR (see ../doc/CNIDR/COPYRIGHT) */


#ifndef _H_Z39_50

#define _H_Z39_50

#include "cdialect.h"

#include "zutil.h"

/*----------------------------------------------------------------------*/
/* APDU types */

typedef struct InitAPDU {
	pdu_type		PDUType;
	boolean			willSearch,willPresent,willDelete;
	boolean			supportAccessControl,supportResourceControl;
	long			PreferredMessageSize;
	long			MaximumRecordSize;
	char*			IDAuthentication;
	char*			ImplementationID;
	char* 			ImplementationName;
	char*			ImplementationVersion;
	any*			ReferenceID;
	void*			UserInformationField;
	} InitAPDU;

typedef struct InitResponseAPDU {
	pdu_type		PDUType;
	boolean			Result;
	boolean			willSearch,willPresent,willDelete;
	boolean			supportAccessControl,supportResourceControl;
	long			PreferredMessageSize;
	long 			MaximumRecordSize;
	char*			IDAuthentication;
	char*			ImplementationID;
	char* 			ImplementationName;
	char*			ImplementationVersion;
	any*			ReferenceID;
	void*			UserInformationField;
	} InitResponseAPDU;

typedef struct SearchAPDU {
	pdu_type		PDUType;
	long	 		SmallSetUpperBound;
	long			LargeSetLowerBound;
	long	 		MediumSetPresentNumber;
	boolean 		ReplaceIndicator;
	char*			ResultSetName;
	char**			DatabaseNames;   
	char*			QueryType;
	char**			ElementSetNames;  
	any*			ReferenceID;
	void*			Query;
	} SearchAPDU;

typedef struct SearchResponseAPDU {
	pdu_type		PDUType;
	long			SearchStatus;
	long			ResultCount;
	long			NumberOfRecordsReturned;
	long		 	NextResultSetPosition;
	long			ResultSetStatus;
	long 			PresentStatus;
	any*			ReferenceID;
	void*			DatabaseDiagnosticRecords;
	} SearchResponseAPDU;

typedef struct PresentAPDU {
	pdu_type		PDUType;
	long			NumberOfRecordsRequested;
	long			ResultSetStartPosition;
	char*		 	ResultSetID;
	char*			ElementSetNames;
	any*			ReferenceID;
	void*			PresentInfo;
	} PresentAPDU;

typedef struct PresentResponseAPDU {
	pdu_type		PDUType;
	boolean			PresentStatus;
	long			NumberOfRecordsReturned;
	long			NextResultSetPosition;
	any*			ReferenceID;
	void*			DatabaseDiagnosticRecords;
	} PresentResponseAPDU;

/*----------------------------------------------------------------------*/
/* Functions */

#ifdef __cplusplus
/* declare these as C style functions */
extern "C"
	{
#endif /* def __cplusplus */

InitAPDU* makeInitAPDU (boolean search,boolean present,boolean deleteIt,
			    boolean accessControl,boolean resourceControl,
			    long prefMsgSize,long maxMsgSize,
			    char* auth,char* id,char* name, char* version,
			    any* refID,void* userInfo);
void freeInitAPDU (InitAPDU* init);
char* writeInitAPDU (InitAPDU* init,char* buffer,long* len);
char* readInitAPDU (InitAPDU** init,char* buffer);


InitResponseAPDU* makeInitResponseAPDU 
(boolean result, boolean search, boolean present, boolean deleteIt,
 boolean accessControl, boolean resourceControl,
 long prefMsgSize, long maxMsgSize,
 char* auth, char* id, char* name, char* version,
 any* refID, void* userInfo);

void freeInitResponseAPDU (InitResponseAPDU* init);
char* writeInitResponseAPDU (InitResponseAPDU* init, char* buffer, long* len);
char* readInitResponseAPDU (InitResponseAPDU** init, char* buffer);

InitResponseAPDU* replyToInitAPDU 
(InitAPDU* init, boolean result, void* userInfo);



SearchAPDU* makeSearchAPDU 
(long small, long large, long medium,
 boolean replace, char* name, char** databases,
 char* type, char** elements, any* refID, void* queryInfo);

void freeSearchAPDU (SearchAPDU* query);

char* writeSearchAPDU (SearchAPDU* query, char* buffer, long* len);

char* readSearchAPDU (SearchAPDU** query, char* buffer);

SearchResponseAPDU* makeSearchResponseAPDU 
(long result, long count, long recordsReturned, long nextPos,
 long resultStatus, long presentStatus, any* refID, void* records);

void freeSearchResponseAPDU (SearchResponseAPDU* queryResponse);

char* writeSearchResponseAPDU 
(SearchResponseAPDU* queryResponse, char* buffer, long* len);

char* readSearchResponseAPDU 
(SearchResponseAPDU** queryResponse, char* buffer);

PresentAPDU* makePresentAPDU 
(long recsReq, long startPos, char* resultID, any* refID, void* info);

void freePresentAPDU (PresentAPDU* present);

char* writePresentAPDU (PresentAPDU* present, char* buffer, long* len);

char* readPresentAPDU (PresentAPDU** present, char* buffer);

PresentResponseAPDU* makePresentResponseAPDU 
(boolean status, long recsRet, long nextPos, any* refID, void* records);

void freePresentResponseAPDU (PresentResponseAPDU* present);
char* writePresentResponseAPDU 
(PresentResponseAPDU* present, char* buffer, long* len);

char* readPresentResponseAPDU (PresentResponseAPDU** present, char* buffer);

/*----------------------------------------------------------------------*/
/* user extension hooks: */

extern char* writeInitInfo (InitAPDU* init, char* buffer, long* len);
extern char* readInitInfo (void** info, char* buffer);

extern char* writeInitResponseInfo 
(InitResponseAPDU* init, char* buffer, long* len);

extern char* readInitResponseInfo (void** info,char* buffer);

extern char* writeSearchInfo (SearchAPDU* query, char* buffer, long* len);
extern char* readSearchInfo (void** info, char* buffer);

extern char* writeSearchResponseInfo 
(SearchResponseAPDU* query, char* buffer, long* len);

extern char* readSearchResponseInfo (void** info, char* buffer);

extern char* writePresentInfo (PresentAPDU* present, char* buffer,long* len);

extern char* readPresentInfo (void** info, char* buffer);

extern char* writePresentResponseInfo 
(PresentResponseAPDU* present, char* buffer,long* len);

extern char* readPresentResponseInfo (void** info,char* buffer);

#ifdef __cplusplus
	}
#endif /* def __cplusplus */

/*----------------------------------------------------------------------*/

#endif /* ndef _H_Z39_50 */


