#ifdef HAVE_JPEG
#include <stdio.h>
#include <X11/Intrinsic.h>

#define MAXCOLORMAPSIZE         256


#include "mosaic.h"
#include "jpeglib.h"
#include <setjmp.h>



extern JSAMPLE * image_buffer;	/* Points to large array of R,G,B-order data */
extern int image_height;	/* Number of rows in image */
extern int image_width;		/* Number of columns in image */


struct my_error_mgr {
  struct jpeg_error_mgr pub;	/* "public" fields */
  jmp_buf setjmp_buffer;	/* for return to caller */
};

typedef struct my_error_mgr * my_error_ptr;


METHODDEF void
my_error_exit (j_common_ptr cinfo)
{
	my_error_ptr myerr = (my_error_ptr) cinfo->err;
	/*fprintf(stderr,"Error reading JPEG image \n");*/
	longjmp(myerr->setjmp_buffer, 1);
}



unsigned char *
ReadJPEG(FILE *infile,int *width, int *height, XColor *colrs)
{
int scale = 65536/MAXCOLORMAPSIZE;
int i;

struct jpeg_decompress_struct cinfo;
struct my_error_mgr jerr;
unsigned char *retBuffer=0;
unsigned char *r;
JSAMPARRAY buffer;		/* Output row buffer */
int row_stride;		/* physical row width in output buffer */

	/*printf("ReadJPEG(): I've been called\n");*/

	/* We set up the normal JPEG error routines, 
		then override error_exit. */
	cinfo.err = jpeg_std_error(&jerr.pub);
	jerr.pub.error_exit = my_error_exit;

	/* Establish the setjmp return context for my_error_exit to use. */

	if (setjmp(jerr.setjmp_buffer)) {
		/* If we get here, the JPEG code has signaled an error. */
    		jpeg_destroy_decompress(&cinfo);
		fclose(infile);

		if (retBuffer) {
			free(retBuffer);
			}
		return 0;
		}

	jpeg_create_decompress(&cinfo);

	jpeg_stdio_src(&cinfo, infile);


	(void) jpeg_read_header(&cinfo, TRUE);


	/* We can ignore the return value from jpeg_read_header since
	*   (a) suspension is not possible with the stdio data source, and
	*   (b) we passed TRUE to reject a tables-only JPEG file as an error.
	* See libjpeg.doc for more info.
	*/

  	cinfo.quantize_colors = TRUE; 
	/*cinfo.desired_number_of_colors = 50;*/
	cinfo.desired_number_of_colors = Rdata.colors_per_inlined_image;
	cinfo.two_pass_quantize = TRUE;
	cinfo.out_color_space = JCS_RGB;


	jpeg_start_decompress(&cinfo);

	if (!(retBuffer = (unsigned char *) malloc(cinfo.output_width 
			* cinfo.output_height * cinfo.output_components))) {
		jpeg_destroy_decompress(&cinfo);
		fprintf(stderr,"Couldn't create space for JPEG read\n");
		return(0);
		}


	row_stride = cinfo.output_width * cinfo.output_components;
	/* Make a one-row-high sample array that will go away when 
			done with image */
	buffer = (*cinfo.mem->alloc_sarray)
                ((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);





	/*
	printf("buffer size is width=%d x height=%d x depth=%d\n",
		cinfo.output_width , cinfo.output_height , 
		cinfo.output_components);
	*/



	r = retBuffer;
	row_stride = cinfo.output_width * cinfo.output_components;
	while (cinfo.output_scanline < cinfo.output_height) {
		(void) jpeg_read_scanlines(&cinfo, buffer, 1);
		memcpy(r,buffer[0],row_stride);
		r += row_stride;
  		}



/*
	(void) jpeg_finish_decompress(&cinfo);
*/


	*width =  cinfo.output_width;
	*height =  cinfo.output_height;

	/* set up X colormap */
	if (cinfo.out_color_components  == 3) {
/*
printf("cinfo.actual_number_of_colors=%d\n",cinfo.actual_number_of_colors);
printf("colrs[0].red=%d colrs[99].red=%d\n",colrs[0].red,colrs[99].red);
printf("cinfo.colormap[0][0]=%d\n",cinfo.colormap[0][0]);
{char dummy[80]; printf("RETURN\n"); gets(dummy);}
*/
		for (i=0; i < cinfo.actual_number_of_colors; i++) {
/*
printf("[%d]\n",i);
*/
			colrs[i].red = cinfo.colormap[0][i] * scale;
			colrs[i].green = cinfo.colormap[1][i]*scale;
			colrs[i].blue = cinfo.colormap[2][i]*scale;
			colrs[i].pixel = i;
			colrs[i].flags = DoRed|DoGreen|DoBlue;
			}
		}
	else {
		for (i=0; i < cinfo.actual_number_of_colors; i++) {
			colrs[i].red = colrs[i].green = 
				colrs[i].blue = cinfo.colormap[0][i] * scale;
			colrs[i].pixel = i;
			colrs[i].flags = DoRed|DoGreen|DoBlue;
			}
		}


  (void) jpeg_finish_decompress(&cinfo);
  jpeg_destroy_decompress(&cinfo);

  return retBuffer;
}

#endif
