/* file_dlg.c - part of asedit program */
/*
 * Copyright 1991 - 1993,  Andrzej Stochniol, London, UK
 *
 * ASEDIT text editor, both binary and source (hereafter, Software) is
 * copyrighted by Andrzej Stochniol (hereafter, AS) and ownership remains
 * with AS.
 *
 * AS grants you (hereafter, Licensee) a license to use the Software
 * for academic, research and internal business purposes only, without a
 * fee.  Licensee may distribute the binary and source code (if released)
 * to third parties provided that the copyright notice and this statement
 * appears on all copies and that no charge is associated with such copies.
 *
 * Licensee may make derivative works.  However, if Licensee distributes
 * any derivative work based on or derived from the Software, then
 * Licensee will:
 * (1) notify AS regarding its distribution of the derivative work, and
 * (2) clearly notify users that such derivative work is a modified version
 *      and not the original ASEDIT distributed by AS.
 *
 * Any Licensee wishing to make commercial use of the Software should
 * contact AS to negotiate an appropriate license for such commercial use.
 * Commercial use includes:
 * (1) integration of all or part of the source code into a product for sale
 *     or license by or on behalf of Licensee to third parties, or 
 * (2) distribution of the binary code or source code to third parties that
 *     need it to utilize a commercial product sold or licensed by or on
 *     behalf of Licensee.
 *
 * A. STOCHNIOL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS
 * SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.  IN NO EVENT SHALL A. STOCHNIOL BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *
 * 	Andrzej Stochniol	(A.Stochniol@ic.ac.uk)
 * 	30 Hatch Road
 * 	London SW16 4PN
 * 	UK
 */


#include <stdio.h>
#include <string.h>

#include <Xm/FileSB.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/Frame.h>
#include <Xm/ToggleB.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include "asedit.h"


/*****************************  show_open_dialog  **************************
**
**  Show open_dialog for the specified asedit window. If it does not exist yet
**  create it first as a child of menu_bar.
*/

#ifdef _NO_PROTO
void show_open_dialog (win)
	aseditWindowStruct *win;
#else  /* ! _NO_PROTO */

void show_open_dialog (aseditWindowStruct *win)
#endif
{
    if(win->open_dialog == NULL)	/* first create a dialog for opening a file  */
    {
	Widget 		kids[3];	/*  children widgets 	*/
	Arg		al[5];		/*  arg list		*/
	register  int	ac = 0;		/*  arg count		*/

	Widget		frame;		/* frame for view_only_toggle */


	win->open_dialog = XmCreateFileSelectionDialog(win->menu_bar,
			   "open_dialog", al, ac);

	XtAddCallback (win->open_dialog, XmNokCallback,
		(XtCallbackProc)DialogOkCB,     mk_asdat_w(win, DIALOG_OPEN));
	XtAddCallback (win->open_dialog, XmNcancelCallback,
		(XtCallbackProc)DialogCancelCB, mk_asdat_w(win, DIALOG_OPEN));
	XtAddCallback (win->open_dialog, XmNhelpCallback,
		(XtCallbackProc)HelpCB,         mk_asdat_w(win, DIALOG_OPEN));

	/* set the colours for editable widgets */
	kids[0] = XmFileSelectionBoxGetChild(win->open_dialog, XmDIALOG_TEXT);
	kids[1] = XmFileSelectionBoxGetChild(win->open_dialog, XmDIALOG_FILTER_TEXT);
	ac =0;
	XtSetArg(al[ac], XmNbackground, select_menu_background); ac++;
	XtSetValues(kids[0], al, ac);
	XtSetValues(kids[1], al, ac);

	ac = 0;
	frame = XmCreateFrame(win->open_dialog, "frame", al,ac);

	ac = 0;
	/* leave the default centre alignment ... it loooks better
		XtSetArg(al[ac], XmNalignment, XmALIGNMENT_BEGINNING); ac++;
	*/
	win->view_only_toggle =  XmCreateToggleButton(frame, "open_view_only", al,ac);

#if (XmVersion == 1000)
	XmAddTabGroup (win->view_only_toggle);
#endif

	XtManageChild(win->view_only_toggle);
	XtManageChild(frame);
    }

    asManageDialog (win->open_dialog);

}   /* show_open_dialog */



/*****************************  show_save_as_dialog  **************************
**
**  Show save_as_dialog for the specified asedit window with a supplied proposed
**  (suggested) filename. If save_as_dialog widget does not exist yet
**  create it first as a child of menu_bar.
*/

#ifdef _NO_PROTO
void show_save_as_dialog (win, proposed_fname)
	aseditWindowStruct *win;
	char *proposed_fname;
#else  /* ! _NO_PROTO */

void show_save_as_dialog (aseditWindowStruct *win, char *proposed_fname)
#endif
{


    Arg			al[5];		/*  arg list		*/
    register  int	ac = 0;		/*  arg count		*/
    XmString  xmstr;            /* work XmString */
    Widget    text;		/* text widget inside the prompt dialog */

    if(win->save_as_dialog == NULL)
    {
	/* create save as dialog */
	XtSetArg (al[ac], XmNautoUnmanage, False);    ac++;
	win->save_as_dialog = XmCreatePromptDialog(win->menu_bar, "save_dialog", al, ac);
	XtAddCallback (win->save_as_dialog, XmNokCallback,
		(XtCallbackProc)DialogOkCB, 	mk_asdat_w(win, DIALOG_SAVE_AS) );
	XtAddCallback (win->save_as_dialog, XmNcancelCallback,
		(XtCallbackProc)DialogCancelCB, mk_asdat_w(win, DIALOG_SAVE_AS) );
	XtAddCallback (win->save_as_dialog,XmNhelpCallback,
		(XtCallbackProc)HelpCB, 	mk_asdat_w(win, DIALOG_SAVE_AS) );

	/* set the colour for the editable text widget */
	text = XmSelectionBoxGetChild(win->save_as_dialog, XmDIALOG_TEXT);
	ac =0;
	XtSetArg(al[ac], XmNbackground, select_menu_background); ac++;
	XtSetValues(text, al, ac);
	/* set a special callback to set the focus to the text widget
	   when the dialog gets its first focus */

	/* unfortunately the idea of setting the keyboard focus to a specific
	   widget when the dialog gets the focus for the first time (using
	   two functions: focusCB, focusTO) DOES NOT work properly on DEC
	   computers with X11R4 and Motif 1.1 !!! so we are making conditional
	   compilation for all such calls.
	   (I have tried also the idea when we register the focus callbacks
	   AFTER all widgets have been managed, but UNFORTUNATELY it didn't
	   work either. Other ways of setting the focus into a predefined
	   widget using keyboard traversal failed as well, mainly because the
	   widget, and all of its ancestors,  does need to be realized BEFORE
	   you call XmProcessTraversal !
	   So I have reluctantly decided to use conditional compilation
	   #ifndef XFOCUS_BUG whenever necessary).
	**/

#ifndef XFOCUS_BUG
	XtAddCallback(win->save_as_dialog, XmNfocusCallback,
			(XtCallbackProc)focusCB, (caddr_t)text);
#endif
    }
    ac = 0;
    xmstr = XmStringCreateLtoR (proposed_fname, charset);

    XtSetArg(al[ac], XmNtextString, xmstr);  ac++;
    XtSetValues(win->save_as_dialog, al, ac);
    XmStringFree(xmstr); 	/* free memory allocated for XmString */
    /* now select all of the text in the text widget so when user start
       typing the proposed file name would be replaced straightaway
       Do that only for non-NULL or zero lenght strings...
       (first get the text widget)
    */
    text = XmSelectionBoxGetChild(win->save_as_dialog, XmDIALOG_TEXT);
    if(proposed_fname && strlen(proposed_fname))
    {
	asManageDialog (win->save_as_dialog);

	XmTextSetSelection(text, 0, XmTextGetLastPosition(text),
				CurrentTime);	/* *USE* the CurrentTime */
			 /**win->timestamp_search_request);***/	/* that trick wroks only every other time ...*/
			/** XtLastTimestampProcessed( display)); **this work only every
				other time .... 
			**/
    }
    else asManageDialog(win->save_as_dialog);

    /* set the keyboard focus to the text widget each time the dialog pops-up */
#if (XmVersion == 1000)
    _XmProcessTraversal( text, XmTRAVERSE_CURRENT);  /** private f. in Motif 1.0 **/
#else
    XmProcessTraversal( text, XmTRAVERSE_CURRENT);
#endif


}   /* show_save_as_dialog */

/*****************************  show_insert_dialog  **************************
**
**  Show insert_dialog for the specified asedit window. If it does not exist yet
**  create it first as a child of menu_bar.
*/

#ifdef _NO_PROTO
void show_insert_dialog (win)
        aseditWindowStruct *win;
#else  /* ! _NO_PROTO */

void show_insert_dialog (aseditWindowStruct *win)
#endif
{
    if(win->insert_dialog == NULL)        /* first create a dialog for inserting a file  */
    {
        Widget          kids[3];        /*  children widgets    */
        Arg             al[5];          /*  arg list            */
        register  int   ac = 0;         /*  arg count           */

        win->insert_dialog = XmCreateFileSelectionDialog(win->menu_bar,
                           "insert_dialog", al, ac);

        XtAddCallback (win->insert_dialog, XmNokCallback,
                (XtCallbackProc)DialogOkCB,     mk_asdat_w(win, DIALOG_INSERT));
        XtAddCallback (win->insert_dialog, XmNcancelCallback,
                (XtCallbackProc)DialogCancelCB, mk_asdat_w(win, DIALOG_INSERT));
        XtAddCallback (win->insert_dialog, XmNhelpCallback,
                (XtCallbackProc)HelpCB,         mk_asdat_w(win, DIALOG_INSERT));

        /* set the colours for editable widgets */
        kids[0] = XmFileSelectionBoxGetChild(win->insert_dialog, XmDIALOG_TEXT);
        kids[1] = XmFileSelectionBoxGetChild(win->insert_dialog, XmDIALOG_FILTER_TEXT);
        ac =0;
        XtSetArg(al[ac], XmNbackground, select_menu_background); ac++;
	XtSetValues(kids[0], al, ac);
        XtSetValues(kids[1], al, ac);
    }

    asManageDialog (win->insert_dialog);

}   /* show_insert_dialog */




/*****************************  show_print_dialog  **************************
**
**  Show print_dialog for the specified asedit window.
**  If print_dialog widget does not exist yet
**  create it first as a child of menu_bar.
*/

#ifdef _NO_PROTO
void show_print_dialog (win)
	aseditWindowStruct *win;
#else  /* ! _NO_PROTO */

void show_print_dialog (aseditWindowStruct *win)
#endif
{


    Arg                 al[10];          /*  arg list            */
    register  int       ac = 0;         /*  arg count           */
    XmString  xmstr;            /* work XmString */
    Widget    text;             /* text widget inside the prompt dialog */

    if(win->print_dialog == NULL)
    {
        /* create print dialog */
	Widget range_radio_box, form;
	Widget frame, print_selection_toggle, range_title;
	Widget kid[3];

	XtSetArg (al[ac], XmNautoUnmanage, False);    ac++;
	win->print_dialog = XmCreateSelectionDialog(win->menu_bar, "print_dialog", al, ac);

	/* unmanage unneeded apply button */
	kid[0] = XmSelectionBoxGetChild(win->print_dialog, XmDIALOG_APPLY_BUTTON);
	XtUnmanageChild (kid[0]);

	XtAddCallback (win->print_dialog, XmNokCallback,
		(XtCallbackProc)DialogOkCB,     mk_asdat_w(win, DIALOG_PRINT_NEW) );
	XtAddCallback (win->print_dialog, XmNcancelCallback,
		(XtCallbackProc)DialogCancelCB, mk_asdat_w(win, DIALOG_PRINT_NEW) );
	XtAddCallback (win->print_dialog,XmNhelpCallback,
		(XtCallbackProc)HelpCB,         mk_asdat_w(win, DIALOG_PRINT_NEW) );

	/* set the colour for the editable text widget */
	text = XmSelectionBoxGetChild(win->print_dialog, XmDIALOG_TEXT);
	ac =0;
	XtSetArg(al[ac], XmNbackground, select_menu_background); ac++;
	XtSetValues(text, al, ac);

	ac = 0;
	form = XmCreateForm ( win->print_dialog, "form", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment,   XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment,  XmATTACH_FORM); ac++;
	range_title = XmCreateLabel ( form, "range_title", al, ac );

	ac=0;
	XtSetArg(al[ac], XmNtopAttachment,   XmATTACH_WIDGET);  ac++;
	XtSetArg(al[ac], XmNtopWidget,       range_title);    ac++;
	XtSetArg(al[ac], XmNleftAttachment,  XmATTACH_FORM);    ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM);    ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM);    ac++;

	frame = XmCreateFrame ( form, "frame", al, ac );

	ac=0;
	range_radio_box = XmCreateRadioBox( frame, "range_radio_box", al, ac );
#if (XmVersion == 1000)
	XmAddTabGroup (range_radio_box);
#endif

	ac=0;
	XtSetArg (al[ac], XmNset, True);  ac++;
	print_selection_toggle =  XmCreateToggleButton(range_radio_box, "selection", al,ac);
	ac = 0;
	win->print_complete_toggle =  XmCreateToggleButton(range_radio_box, "complete", al,ac);

	 /* manage the children and manage the manager parents as we ascend back up*/

	ac = 0;
	kid[ac++] = print_selection_toggle;
	kid[ac++] = win->print_complete_toggle;
	XtManageChildren(kid, ac);
	XtManageChild(range_radio_box);

	ac = 0;
	kid[ac++] = frame;
	kid[ac++] = range_title;
	XtManageChildren(kid, ac);
	XtManageChild(form);



	/* set a special callback to set the focus to the text widget
	   when the dialog gets its first focus */

#ifndef XFOCUS_BUG
	XtAddCallback(win->print_dialog, XmNfocusCallback,
			(XtCallbackProc)focusCB, (caddr_t)text);
#endif
    }
    text = XmSelectionBoxGetChild(win->print_dialog, XmDIALOG_TEXT);

    asManageDialog(win->print_dialog);

    /* set the keyboard focus to the text widget each time the dialog pops-up */
#if (XmVersion == 1000)
    _XmProcessTraversal( text, XmTRAVERSE_CURRENT);  /** private f. in Motif 1.0 **/
#else
    XmProcessTraversal( text, XmTRAVERSE_CURRENT);
#endif


}   /* show_print_dialog */



/***********************  show_save_changes_dialog  ************************
**
**  Show save_changes_dialog for the specified asedit window. If it does not
**  exist yet create it first as a child of ** toplevel ** (it must be
**  possible to show the dialog even when the asedit window is iconized !!)
*/

#ifdef _NO_PROTO
void show_save_changes_dialog (win)
	aseditWindowStruct *win;
#else  /* ! _NO_PROTO */

void show_save_changes_dialog (aseditWindowStruct *win)
#endif
{
    Arg			al[7];		/*  arg list		*/
    register  int	ac = 0;		/*  arg count		*/
    char 		work[326];
    XmString		xmstr;		/*  work XmString */
    Widget		label;		

    if(win->save_changes_dialog == NULL)	/* first create the dialog  */
    {
	Dimension width, height;

	/* create save changes warning dialog */
	XtSetArg(al[ac], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); ac++;
	XtSetArg (al[ac], XmNautoUnmanage, False);    ac++;
	XtSetArg (al[ac], XmNdefaultPosition, False); ac++;

	win->save_changes_dialog = create_4buttons_image_dialog( toplevel, "save_warning",
				      "as_warning_image", (char *)lstr.fq_save_changes, al, ac);
	ac = 0;
	XtSetArg(al[ac], XmNwidth,  &width);    ac++;
        XtSetArg(al[ac], XmNheight, &height);   ac++;
	XtGetValues (win->save_changes_dialog, al, ac);

	/* initially position the dialog in the middle of the screen */
	ac = 0;
	XtSetArg(al[ac], XmNx, (WidthOfScreen(XtScreen(toplevel))-width)/2);  ac++;
	XtSetArg(al[ac], XmNy, (HeightOfScreen(XtScreen(toplevel))-height)/2);  ac++;
	XtSetValues (win->save_changes_dialog, al, ac);
	
	XtAddCallback (win->save_changes_dialog, XmNokCallback,
		       (XtCallbackProc)DialogOkCB, 	mk_asdat_w(win, DIALOG_SAVE_CHANGES) );
        XtAddCallback (win->save_changes_dialog, XmNapplyCallback,            /* No answer */
                        (XtCallbackProc)DialogApplyCB,  mk_asdat_w(win, DIALOG_SAVE_CHANGES) );
	XtAddCallback (win->save_changes_dialog, XmNcancelCallback,
		       (XtCallbackProc)DialogCancelCB,  mk_asdat_w(win, DIALOG_SAVE_CHANGES) );
	XtAddCallback (win->save_changes_dialog, XmNhelpCallback,
		       (XtCallbackProc)HelpCB, mk_asdat_w(win, DIALOG_SAVE_CHANGES) );
    }

    /* get the label widget inside save_changes_dialog from the userData resource */
    ac = 0;
    XtSetArg(al[ac], XmNuserData, &label);  ac++;
    XtGetValues(win->save_changes_dialog, al, ac);

    ac = 0;
    sprintf(work,"%s\n%s ?",(char *)lstr.fq_save_changes, win->filename);

    xmstr = XmStringCreateLtoR(work, charset);
    XtSetArg(al[ac], XmNlabelString, xmstr );  ac++;
    XtSetValues(label, al, ac);
    XmStringFree(xmstr);

    asManageDialog (win->save_changes_dialog);


}   /* show_save_changes_dialog */



/***********************  show_overwrite_question  ************************
**
**  Show overwrite_question for the specified asedit window. If it does not
**  exist yet create it first as a child of menu_bar.
*/

#ifdef _NO_PROTO
void show_overwrite_question (win, filename)
	aseditWindowStruct *win;
	char 	           *filename;
#else  /* ! _NO_PROTO */

void show_overwrite_question (aseditWindowStruct *win, char *filename)
#endif
{
    Arg			al[5];		/*  arg list		*/
    register  int	ac = 0;		/*  arg count		*/
    char 		work[326];
    XmString		xmstr;		/*  work XmString */


    if(win->overwrite_question == NULL)	/* first create the dialog  */
    {

	/* create the overwrite_question widget */
	ac = 0;
	strcpy(work, (char *)lstr.fq_overwrite);
	xmstr = XmStringCreateLtoR(work, charset);
	XtSetArg(al[ac], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); ac++;
	XtSetArg (al[ac], XmNautoUnmanage, False);    ac++;
	XtSetArg(al[ac], XmNmessageString, xmstr );  ac++;
	win->overwrite_question = XmCreateQuestionDialog (win->menu_bar, "overwrite_question",al,ac);
	XmStringFree(xmstr);		/* free memory allocated for XmString */

	XtAddCallback (win->overwrite_question, XmNokCallback,
			(XtCallbackProc)DialogOkCB,     mk_asdat_w(win, QUESTION_OVERWRITE) );
	XtAddCallback (win->overwrite_question, XmNcancelCallback,
			(XtCallbackProc)DialogCancelCB, mk_asdat_w(win, QUESTION_OVERWRITE) );
	XtAddCallback (win->overwrite_question, XmNhelpCallback,
			(XtCallbackProc)HelpCB,         mk_asdat_w(win, QUESTION_OVERWRITE) );

    }
    ac = 0;
    strcpy(work, (char *)lstr.fq_overwrite);
    if(filename) strcat(work, filename); /* there is apparently a bug on SG
					when you try to strcat NULL string, so I
					make conditional strcat .... (11.03.92) */
    xmstr = XmStringCreateLtoR(work, charset);
    XtSetArg(al[ac], XmNmessageString, xmstr );  ac++;
    XtSetValues(win->overwrite_question, al, ac);
    XmStringFree(xmstr);
    asManageDialog (win->overwrite_question);

}   /*  show_overwrite_question */


#include "warning.xbm"
#include "question.xbm"

/*****************************  install_as_images  **************************
**
**	Install as's images needed by asedit in different dialogs.
*/
#ifdef _NO_PROTO
void install_as_images (parent)
    Widget parent;
#else  /* ! _NO_PROTO */

void install_as_images (Widget parent)
#endif
{
    XImage		*image;		/*  image for warning pixmap	*/
    XImage		*image2;
    Pixel           foreground;     /*  dialog foreground             */
    Pixel           background;     /*  dialog background             */
    Arg             al[10];         /*  arg list                      */
    register int    ac;             /*  arg count                     */


    image = CreateDefaultImage (warning_bits, warning_width, warning_height);
    XmInstallImage (image, "as_warning_image");

    image2 = CreateDefaultImage (question_bits, question_width, question_height);
    XmInstallImage (image2, "as_question_image");

    /* get the colours to be used for pixmap */
    ac = 0;
    XtSetArg(al[ac], XmNforeground, &foreground); ac++;
    XtSetArg(al[ac], XmNbackground, &background); ac++;
    XtGetValues(parent, al, ac);

    xm_question_mark = XmGetPixmap(XtScreen(parent), "as_question_image",
                             foreground, background);


}   /* install_as_images */


