#include <stdio.h>
#include <sys/signal.h>
#include "enable.h"
/* enable [ttyydev]
   disable [ttydev]

   enable with arguments adjust /etc/ttys to reflect new on condition
	and signals init about it. Without arguments reports enabled
	terminals.
   disable does the opposite.

   enable and disable are the same image, function is selected by
	name in argv[0]
*/
#define TTYS "/etc/ttys"
main(argc,argv)
int argc;
char *argv[];
{
FILE *t,*nf;
char bfr[255];
struct ttysent *newb,*splitline(); /* ttysent is not the same as ttyent */
char target[8];
int found=0;			/* if we found THIS terminal */
int display=0;			/* show us */
int func=0;
char *s;

	if(argc == 1){
		display =1;
	}
	if(strstr(argv[0],"enable")){
		strcpy(target,"on");
		func = ENABLE;
	}
	if(strstr(argv[0],"disable")){
		strcpy(target,"off");
		func = DISABLE;
	}
	if(func == 0)exit (2);
	t = fopen(TTYS,"r");
	if(t == NULL){
		perror(TTYS);
		exit (1);
	}
	if(display){	/* show terminals */
		do{
			s = fgets(bfr,sizeof(bfr),t);
			newb = splitline(bfr);
			if(!newb) /* comment */
				continue;
			if (strstr(newb->onoff,target))
				printf("%s ",newb->term);
		}while(s != NULL);
		printf("\n");
	}else{		/* change terminals */
		if(link(TTYS,TTYS".tmp")){ /* create new file */
			perror(TTYS".tmp");
			exit(3);
		}
		if(unlink(TTYS)){
			perror(TTYS);
			exit(4);
		}
		nf=fopen(TTYS,"w");
		if(!nf){
			perror(TTYS);
			exit(5);
		}
		do{
			s = fgets(bfr,sizeof(bfr),t);
			if(s == NULL)break;
			newb = splitline(bfr);
			if(!newb){ /* comment */
				fprintf(nf,"%s",bfr);
				continue;
			}
			if(strstr(newb->term,argv[1])){	/* got it */
				strcpy(newb->onoff,target);
				found =1;
			}
			fprintf(nf,"%-8s ",newb->term);
			fprintf(nf,"%-30s ",newb->getty);
			fprintf(nf,"%-8s ",newb->type);
			fprintf(nf,"%-4s ",newb->onoff);
			/* end of req. fields */
			if(newb->secure[0] != NULL)
				fprintf(nf,"%s ",newb->secure);
			if(newb->window[0] != NULL)
				fprintf(nf,"%s ",newb->window);
			if(newb->comment[0] != NULL)
				fprintf(nf,"%s ",newb->comment);
			fprintf(nf,"\n");
		}while (s != NULL);
		fclose(nf);
		unlink(TTYS".tmp");
		if(found)	/* no use waisting signals if nothing changed */
			kill(1,SIGHUP);
		else
			printf("%s not in %s\n",argv[1],TTYS);
	}
	fclose(t);
}
