/*
 * Copyright (c) 1994, 1995.  Netscape Communications Corporation.  All
 * rights reserved.
 * 
 * Use of this software is governed by the terms of the license agreement for
 * the Netscape FastTrack or Netscape Enterprise Server between the
 * parties.
 */


/* ------------------------------------------------------------------------ */


/*
 * systhr.h: Abstracted threading mechanisms
 * 
 * Rob McCool
 */

#ifndef _SYSTHR_H
#define _SYSTHR_H

#include "netsite.h"
#include "systems.h"

#ifdef THREAD_ANY


typedef void* SYS_THREAD;
#define SYS_THREAD_ERROR NULL


/*
 * systhread_start creates a thread with the given priority, will allocate
 * a stack of stksz bytes, and calls fn with arg as its argument. stksz
 * of zero will allocate a default stack size. 
 * 
 * Returns a new SYS_THREAD pointer on success, SYS_THREAD_ERROR on failure.
 * XXX Priorities are system dependent
 */
#define SYSTHREAD_DEFAULT_PRIORITY 16

NSAPI_PUBLIC
SYS_THREAD systhread_start(int prio, int stksz, void (*fn)(void *), void *arg);


/* 
 * systhread_current returns a pointer to the current thread.
 */

NSAPI_PUBLIC SYS_THREAD systhread_current(void);

/*
 * systhread_yield yields the processor to another thread
 */

NSAPI_PUBLIC void systhread_yield(void);

/*
 * systhread_attach makes an existing thread an NSPR thread.
 */
NSAPI_PUBLIC SYS_THREAD systhread_attach(void);

/* 
 * systhread_terminate terminates the thread that is passed in.
 */
NSAPI_PUBLIC void systhread_terminate(SYS_THREAD thr);


/*
 * systhread_sleep puts the calling thread to sleep for the given number
 * of milliseconds.
 */
NSAPI_PUBLIC void systhread_sleep(int milliseconds);

/*
 * systhread_init initializes the threading system. name is a name for the
 * program for debugging.
 */

NSAPI_PUBLIC void systhread_init(char *name);

/*
 * systhread_timerset starts or re-sets the interrupt timer for a thread
 * system. This should be considered a suggestion as most systems don't allow
 * the timer interval to be changed.
 */

NSAPI_PUBLIC void systhread_timerset(int usec);


/*
 * newkey allocates a new integer id for thread-private data. Use this
 * key to identify a variable which you want to appear differently 
 * between threads, and then use setdata to associate a value with this
 * key for each thread.
 */
NSAPI_PUBLIC int systhread_newkey(void);

/*
 * Get data that has been previously associated with key in this thread.
 * Returns NULL if setkey has not been called with this key by this 
 * thread previously, or the data that was previously used with setkey
 * by this thread with this key.
 */
NSAPI_PUBLIC void *systhread_getdata(int key);

/*
 * Associate data with the given key number in this thread.
 */
NSAPI_PUBLIC void systhread_setdata(int key, void *data);

#endif
#endif
